/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.dag;

import net.automatalib.incremental.mealy.dag.StateSignature;

public final class State {
    private int numIncoming;
    private final StateSignature signature;

    public State(StateSignature signature) {
        this.signature = signature;
    }

    public void increaseIncoming() {
        ++this.numIncoming;
    }

    public void decreaseIncoming() {
        --this.numIncoming;
    }

    public int getNumIncoming() {
        return this.numIncoming;
    }

    public boolean isConfluence() {
        return this.numIncoming > 1;
    }

    public State getSuccessor(int idx) {
        return this.signature.successors[idx];
    }

    public Object getOutput(int idx) {
        return this.signature.outputs[idx];
    }

    public StateSignature getSignature() {
        return this.signature;
    }
}

