/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.fsa.impl.compact.CompactNFA;
import net.automatalib.words.Alphabet;

public interface SerializationProvider {
    default public CompactDFA<?> readNativeDFA(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            CompactDFA<?> compactDFA = this.readNativeDFA(is);
            return compactDFA;
        }
    }

    default public CompactDFA<?> readNativeDFA(File f) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(f);){
            CompactDFA<?> compactDFA = this.readNativeDFA(is);
            return compactDFA;
        }
    }

    default public CompactDFA<?> readNativeDFA(byte[] buf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            CompactDFA<?> compactDFA = this.readNativeDFA(is);
            return compactDFA;
        }
    }

    default public CompactDFA<?> readNativeDFA(InputStream is) throws IOException {
        return this.readGenericDFA(is);
    }

    default public CompactDFA<Integer> readGenericDFA(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            CompactDFA<Integer> compactDFA = this.readGenericDFA(is);
            return compactDFA;
        }
    }

    default public CompactDFA<Integer> readGenericDFA(File f) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(f);){
            CompactDFA<Integer> compactDFA = this.readGenericDFA(is);
            return compactDFA;
        }
    }

    default public CompactDFA<Integer> readGenericDFA(byte[] buf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            CompactDFA<Integer> compactDFA = this.readGenericDFA(is);
            return compactDFA;
        }
    }

    public CompactDFA<Integer> readGenericDFA(InputStream var1) throws IOException;

    default public <I> CompactDFA<I> readCustomDFA(URL url, Alphabet<I> alphabet) throws IOException {
        try (InputStream is = url.openStream();){
            CompactDFA<I> compactDFA = this.readCustomDFA(is, alphabet);
            return compactDFA;
        }
    }

    default public <I> CompactDFA<I> readCustomDFA(File f, Alphabet<I> alphabet) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            CompactDFA<I> compactDFA = this.readCustomDFA(is, alphabet);
            return compactDFA;
        }
    }

    default public <I> CompactDFA<I> readCustomDFA(byte[] buf, Alphabet<I> alphabet) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            CompactDFA<I> compactDFA = this.readCustomDFA(is, alphabet);
            return compactDFA;
        }
    }

    default public <I> CompactDFA<I> readCustomDFA(InputStream is, Alphabet<I> alphabet) throws IOException {
        CompactDFA<?> dfa = this.readNativeDFA(is);
        return dfa.translate(alphabet);
    }

    public <I> void writeDFA(DFA<?, I> var1, Alphabet<I> var2, OutputStream var3) throws IOException;

    default public <I> void writeDFA(DFA<?, I> dfa, Alphabet<I> alphabet, File f) throws FileNotFoundException, IOException {
        try (FileOutputStream os = new FileOutputStream(f);){
            this.writeDFA(dfa, alphabet, os);
        }
    }

    default public <I> byte[] encodeDFA(DFA<?, I> dfa, Alphabet<I> alphabet) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.writeDFA(dfa, alphabet, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    default public CompactNFA<?> readNativeNFA(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            CompactNFA<?> compactNFA = this.readNativeNFA(is);
            return compactNFA;
        }
    }

    default public CompactNFA<?> readNativeNFA(File f) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(f);){
            CompactNFA<?> compactNFA = this.readNativeNFA(is);
            return compactNFA;
        }
    }

    default public CompactNFA<?> readNativeNFA(byte[] buf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            CompactNFA<?> compactNFA = this.readNativeNFA(is);
            return compactNFA;
        }
    }

    default public CompactNFA<?> readNativeNFA(InputStream is) throws IOException {
        return this.readGenericNFA(is);
    }

    default public CompactNFA<Integer> readGenericNFA(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            CompactNFA<Integer> compactNFA = this.readGenericNFA(is);
            return compactNFA;
        }
    }

    default public CompactNFA<Integer> readGenericNFA(File f) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(f);){
            CompactNFA<Integer> compactNFA = this.readGenericNFA(is);
            return compactNFA;
        }
    }

    default public CompactNFA<Integer> readGenericNFA(byte[] buf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            CompactNFA<Integer> compactNFA = this.readGenericNFA(is);
            return compactNFA;
        }
    }

    public CompactNFA<Integer> readGenericNFA(InputStream var1) throws IOException;

    default public <I> CompactNFA<I> readCustomNFA(URL url, Alphabet<I> alphabet) throws IOException {
        try (InputStream is = url.openStream();){
            CompactNFA<I> compactNFA = this.readCustomNFA(is, alphabet);
            return compactNFA;
        }
    }

    default public <I> CompactNFA<I> readCustomNFA(File f, Alphabet<I> alphabet) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            CompactNFA<I> compactNFA = this.readCustomNFA(is, alphabet);
            return compactNFA;
        }
    }

    default public <I> CompactNFA<I> readCustomNFA(byte[] buf, Alphabet<I> alphabet) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            CompactNFA<I> compactNFA = this.readCustomNFA(is, alphabet);
            return compactNFA;
        }
    }

    default public <I> CompactNFA<I> readCustomNFA(InputStream is, Alphabet<I> alphabet) throws IOException {
        CompactNFA<?> nfa = this.readNativeNFA(is);
        return nfa.translate(alphabet);
    }

    public <I> void writeNFA(NFA<?, I> var1, Alphabet<I> var2, OutputStream var3) throws IOException;

    default public <I> void writeNFA(NFA<?, I> nfa, Alphabet<I> alphabet, File f) throws FileNotFoundException, IOException {
        try (FileOutputStream os = new FileOutputStream(f);){
            this.writeNFA(nfa, alphabet, os);
        }
    }

    default public <I> byte[] encodeNFA(NFA<?, I> nfa, Alphabet<I> alphabet) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.writeNFA(nfa, alphabet, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }
}

