/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.saf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.fsa.impl.compact.CompactNFA;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.serialization.SerializationProvider;
import net.automatalib.serialization.saf.SAFInput;
import net.automatalib.words.Alphabet;

public class SAFSerialization
implements SerializationProvider {
    private static final SAFSerialization INSTANCE = new SAFSerialization();

    public static SAFSerialization getInstance() {
        return INSTANCE;
    }

    private SAFSerialization() {
    }

    @Override
    public CompactDFA<Integer> readGenericDFA(InputStream is) throws IOException {
        is = IOUtil.asUncompressedInputStream(is);
        SAFInput in = new SAFInput(is);
        return in.readNativeDFA();
    }

    @Override
    public <I> void writeDFA(DFA<?, I> dfa, Alphabet<I> alphabet, OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompactNFA<Integer> readGenericNFA(InputStream is) throws IOException {
        is = IOUtil.asUncompressedInputStream(is);
        SAFInput in = new SAFInput(is);
        return in.readNativeNFA();
    }

    @Override
    public <I> void writeNFA(NFA<?, I> nfa, Alphabet<I> alphabet, OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    static enum AutomatonType {
        DFA(true),
        NFA(false),
        MEALY(true);

        private final boolean deterministic;

        public boolean isDeterministic() {
            return this.deterministic;
        }

        private AutomatonType(boolean deterministic) {
            this.deterministic = deterministic;
        }
    }
}

