/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.fsa.impl.compact.CompactNFA;
import net.automatalib.serialization.SerializationProvider;
import net.automatalib.serialization.taf.parser.PrintStreamDiagnosticListener;
import net.automatalib.serialization.taf.parser.TAFParser;
import net.automatalib.serialization.taf.writer.TAFWriter;
import net.automatalib.util.automata.copy.AutomatonCopyMethod;
import net.automatalib.util.automata.copy.AutomatonLowLevelCopy;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public class TAFSerialization
implements SerializationProvider {
    private static TAFSerialization INSTANCE = new TAFSerialization();

    public static TAFSerialization getInstance() {
        return INSTANCE;
    }

    private TAFSerialization() {
    }

    @Override
    public CompactDFA<Integer> readGenericDFA(InputStream is) throws IOException {
        CompactDFA<String> nativeDfa = this.readNativeDFA(is);
        return TAFSerialization.normalize(nativeDfa, nativeDfa.getInputAlphabet());
    }

    public CompactDFA<String> readNativeDFA(InputStream is) {
        return TAFParser.parseDFA(is, PrintStreamDiagnosticListener.getStderrDiagnosticListener());
    }

    @Override
    public <I> void writeDFA(DFA<?, I> dfa, Alphabet<I> alphabet, OutputStream os) throws IOException {
        TAFWriter.writeDFA(dfa, alphabet, new OutputStreamWriter(os));
    }

    @Override
    public CompactNFA<Integer> readGenericNFA(InputStream is) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <I> void writeNFA(NFA<?, I> nfa, Alphabet<I> alphabet, OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static <I> CompactDFA<Integer> normalize(DFA<?, I> dfa, Alphabet<I> alphabet) {
        Alphabet<Integer> normalizedAlphabet = Alphabets.integers(0, alphabet.size() - 1);
        CompactDFA<Integer> result = new CompactDFA<Integer>(normalizedAlphabet, dfa.size());
        AutomatonLowLevelCopy.copy(AutomatonCopyMethod.STATE_BY_STATE, dfa, alphabet, result, i -> alphabet.getSymbolIndex(i));
        return result;
    }
}

