/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.commons.util.strings.StringUtil;
import net.automatalib.serialization.taf.parser.InternalTAFParser;
import net.automatalib.serialization.taf.parser.TAFBuilder;
import net.automatalib.words.Alphabet;

abstract class AbstractTAFBuilder<S, I, T, SP, TP, M extends MutableDeterministic<S, I, T, SP, TP>>
implements TAFBuilder {
    private static final Pattern idPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private final InternalTAFParser parser;
    protected M automaton;
    private Alphabet<String> alphabet;
    private final Map<String, S> stateMap = new HashMap<String, S>();
    private final Set<String> declaredStates = new HashSet<String>();

    protected abstract M createAutomaton(Alphabet<String> var1);

    protected abstract SP getStateProperty(Set<String> var1);

    protected abstract I translateInput(String var1);

    public AbstractTAFBuilder(InternalTAFParser parser) {
        this.parser = parser;
    }

    @Override
    public void init(Alphabet<String> alphabet) {
        if (this.automaton != null) {
            throw new IllegalStateException();
        }
        this.automaton = this.createAutomaton(alphabet);
        this.alphabet = alphabet;
    }

    public M finish() {
        this.checkState();
        this.stateMap.clear();
        this.declaredStates.clear();
        M result = this.automaton;
        this.automaton = null;
        this.alphabet = null;
        return result;
    }

    @Override
    public void declareState(String identifier, Set<String> options) {
        boolean init;
        if (!this.declaredStates.add(identifier)) {
            this.error("State {0} declared twice", identifier);
        }
        if ((init = options.remove("initial") | options.remove("init")) && this.automaton.getInitialState() != null) {
            this.error("Duplicate initial state {0}", identifier);
            init = false;
        }
        S state = this.stateMap.get(identifier);
        SP property = this.getStateProperty(options);
        if (state == null) {
            state = init ? this.automaton.addInitialState(property) : this.automaton.addState(property);
            this.stateMap.put(identifier, state);
        } else {
            this.automaton.setStateProperty(state, property);
            if (init) {
                this.automaton.setInitialState(state);
            }
        }
        if (!options.isEmpty()) {
            this.warning("Unrecognized options for state {0}: {1}", identifier, options);
        }
    }

    protected void doAddTransitions(String source, Collection<String> symbols, String target, TP transProperty) {
        S src = this.lookupState(source);
        S tgt = this.lookupState(target);
        ArrayList<String> invalidSymbols = new ArrayList<String>();
        for (String s : symbols) {
            if (!this.alphabet.containsSymbol(s)) {
                invalidSymbols.add(StringUtil.enquoteIfNecessary(s, idPattern));
                continue;
            }
            I input = this.translateInput(s);
            Object exTrans = this.automaton.getTransition(src, input);
            if (exTrans != null) {
                if (!Objects.equals(tgt, this.automaton.getSuccessor(exTrans))) {
                    this.error("Duplicate transition from {0} on input {1} to differing target {2} would introduce non-determinism", source, StringUtil.enquoteIfNecessary(s, idPattern), tgt);
                    continue;
                }
                if (Objects.equals(transProperty, this.automaton.getTransitionProperty(exTrans))) continue;
                this.error("Duplicate transition from {0} on input {1} to {2} with differing property '{3}' would introduce non-determinism", source, StringUtil.enquoteIfNecessary(s, idPattern), tgt, transProperty);
                continue;
            }
            this.automaton.addTransition(src, input, tgt, transProperty);
        }
        if (!invalidSymbols.isEmpty()) {
            this.error("Invalid symbols for transition from {0} to {1}: {2}", source, target, invalidSymbols);
        }
    }

    protected void doAddWildcardTransitions(String source, String target, TP transProperty) {
        S src = this.lookupState(source);
        S tgt = this.lookupState(target);
        for (String s : this.alphabet) {
            I input = this.translateInput(s);
            Object exTrans = this.automaton.getTransition(src, input);
            if (exTrans != null) continue;
            this.automaton.addTransition(src, input, tgt, transProperty);
        }
    }

    protected S lookupState(String identifier) {
        S state = this.stateMap.get(identifier);
        if (state == null) {
            state = this.automaton.addState();
            this.stateMap.put(identifier, state);
        }
        return state;
    }

    protected void error(String msgFmt, Object ... args) {
        this.parser.error(msgFmt, args);
    }

    protected void warning(String msgFmt, Object ... args) {
        this.parser.warning(msgFmt, args);
    }

    protected void checkState() {
        if (this.automaton == null) {
            throw new IllegalStateException();
        }
    }
}

