/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.serialization.taf.parser.DefaultTAFBuilderDFA;
import net.automatalib.serialization.taf.parser.DefaultTAFBuilderMealy;
import net.automatalib.serialization.taf.parser.InternalTAFParser;
import net.automatalib.serialization.taf.parser.ParseException;
import net.automatalib.serialization.taf.parser.TAFParseDiagnosticListener;
import net.automatalib.serialization.taf.parser.TAFParseException;
import net.automatalib.serialization.taf.parser.Type;

public class TAFParser {
    public static CompactDFA<String> parseDFA(Reader reader, TAFParseDiagnosticListener listener) throws TAFParseException {
        InternalTAFParser parser = new InternalTAFParser(reader);
        parser.setDiagnosticListener(listener);
        DefaultTAFBuilderDFA builder = new DefaultTAFBuilderDFA(parser);
        try {
            parser.dfa(builder);
        }
        catch (ParseException ex) {
            throw new TAFParseException(ex);
        }
        return (CompactDFA)builder.finish();
    }

    public static CompactDFA<String> parseDFA(InputStream stream, TAFParseDiagnosticListener listener) throws TAFParseException {
        return TAFParser.parseDFA(new InputStreamReader(stream), listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompactDFA<String> parseDFA(File file, TAFParseDiagnosticListener listener) throws TAFParseException {
        try (BufferedReader r = new BufferedReader(new FileReader(file));){
            CompactDFA<String> compactDFA = TAFParser.parseDFA(r, listener);
            return compactDFA;
        }
        catch (IOException ex) {
            throw new TAFParseException(ex);
        }
    }

    public static CompactDFA<String> parseDFA(String string, TAFParseDiagnosticListener listener) throws TAFParseException {
        return TAFParser.parseDFA(new StringReader(string), listener);
    }

    public static CompactMealy<String, String> parseMealy(Reader reader, TAFParseDiagnosticListener listener) throws TAFParseException {
        InternalTAFParser parser = new InternalTAFParser(reader);
        parser.setDiagnosticListener(listener);
        DefaultTAFBuilderMealy builder = new DefaultTAFBuilderMealy(parser);
        try {
            parser.mealy(builder);
        }
        catch (ParseException ex) {
            throw new TAFParseException(ex);
        }
        return (CompactMealy)builder.finish();
    }

    public static CompactMealy<String, String> parseMealy(InputStream stream, TAFParseDiagnosticListener listener) throws TAFParseException {
        return TAFParser.parseMealy(new InputStreamReader(stream), listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompactMealy<String, String> parseMealy(File file, TAFParseDiagnosticListener listener) throws TAFParseException {
        try (BufferedReader r = new BufferedReader(new FileReader(file));){
            CompactMealy<String, String> compactMealy = TAFParser.parseMealy(r, listener);
            return compactMealy;
        }
        catch (IOException ex) {
            throw new TAFParseException(ex);
        }
    }

    public static CompactMealy<String, String> parseMealy(String string, TAFParseDiagnosticListener listener) throws TAFParseException {
        return TAFParser.parseMealy(new StringReader(string), listener);
    }

    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(Reader reader, TAFParseDiagnosticListener listener) throws TAFParseException {
        InternalTAFParser parser = new InternalTAFParser(reader);
        parser.setDiagnosticListener(listener);
        try {
            Type type = parser.type();
            switch (type) {
                case DFA: {
                    DefaultTAFBuilderDFA builder = new DefaultTAFBuilderDFA(parser);
                    parser.dfaBody(builder);
                    return (FiniteAlphabetAutomaton)builder.finish();
                }
                case MEALY: {
                    DefaultTAFBuilderMealy builder = new DefaultTAFBuilderMealy(parser);
                    parser.mealyBody(builder);
                    return (FiniteAlphabetAutomaton)builder.finish();
                }
            }
        }
        catch (ParseException ex) {
            throw new TAFParseException(ex);
        }
        throw new IllegalArgumentException();
    }

    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(InputStream stream, TAFParseDiagnosticListener listener) throws TAFParseException {
        return TAFParser.parseAny(new InputStreamReader(stream), listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(File file, TAFParseDiagnosticListener listener) throws TAFParseException {
        try (BufferedReader r = new BufferedReader(new FileReader(file));){
            FiniteAlphabetAutomaton<?, String, ?> finiteAlphabetAutomaton = TAFParser.parseAny(r, listener);
            return finiteAlphabetAutomaton;
        }
        catch (IOException ex) {
            throw new TAFParseException(ex);
        }
    }

    public static FiniteAlphabetAutomaton<?, String, ?> parseAny(String string, TAFParseDiagnosticListener listener) throws TAFParseException {
        return TAFParser.parseDFA(new StringReader(string), listener);
    }
}

