/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf.writer;

import com.google.common.base.Function;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.commons.util.Pair;
import net.automatalib.commons.util.strings.StringUtil;

public class TAFWriter {
    private static final Pattern idPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private final Appendable out;
    private int indent;

    private TAFWriter(Appendable out) {
        this.out = out;
    }

    private void begin(String type, Collection<?> inputs) throws IOException {
        this.writeIndent();
        this.out.append(type).append(' ');
        this.writeStringCollection(inputs);
        this.out.append(" {\n");
        ++this.indent;
    }

    private void end() throws IOException {
        --this.indent;
        this.writeIndent();
        this.out.append("}\n");
    }

    private void writeIndent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.out.append('\t');
        }
    }

    private void beginState(String name, Set<String> options) throws IOException {
        this.writeIndent();
        this.out.append(name).append(' ');
        if (options != null && !options.isEmpty()) {
            this.out.append(options.toString()).append(' ');
        }
        this.out.append("{\n");
        ++this.indent;
    }

    private void endState() throws IOException {
        --this.indent;
        this.writeIndent();
        this.out.append("}\n");
    }

    private void writeTransition(Collection<?> symbols, String target, Object output) throws IOException {
        this.writeIndent();
        this.writeStringCollection(symbols);
        if (output != null) {
            this.out.append(" / ").append(output.toString());
        }
        this.out.append(" -> ").append(target).append('\n');
    }

    private void writeStringCollection(Collection<?> symbols) throws IOException {
        if (symbols.isEmpty()) {
            this.out.append("{}");
        } else if (symbols.size() == 1) {
            StringUtil.enquoteIfNecessary(symbols.iterator().next().toString(), this.out, idPattern);
        } else {
            this.out.append('{');
            boolean first = true;
            for (Object sym : symbols) {
                if (first) {
                    first = false;
                } else {
                    this.out.append(',');
                }
                StringUtil.enquoteIfNecessary(sym.toString(), this.out, idPattern);
            }
            this.out.append('}');
        }
    }

    private <S, I, T> void doWriteAutomaton(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Collection<? extends I> inputs, String type, Function<S, ? extends Collection<? extends String>> spExtractor) throws IOException {
        this.begin(type, inputs);
        Object init = automaton.getInitialState();
        StateIDs<Object> ids = automaton.stateIDs();
        for (Object state : automaton) {
            HashSet<String> options = new HashSet<String>((Collection)spExtractor.apply(state));
            if (Objects.equals(init, state)) {
                options.add("initial");
            }
            int id = ids.getStateId(state);
            String name = "s" + id;
            this.beginState(name, options);
            Map groupedTransitions = inputs.stream().map(i -> new Pair(i, automaton.getTransition(state, i))).filter(p -> p.getSecond() != null).collect(Collectors.groupingBy(p -> new Pair(automaton.getSuccessor(p.getSecond()), automaton.getTransitionProperty(p.getSecond())), Collectors.mapping(p -> p.getFirst(), Collectors.toList())));
            for (Map.Entry group : groupedTransitions.entrySet()) {
                Object tgt = group.getKey().getFirst();
                int tgtId = ids.getStateId(tgt);
                String tgtName = "s" + tgtId;
                Object transProp = group.getKey().getSecond();
                this.writeTransition(group.getValue(), tgtName, transProp);
            }
            this.endState();
        }
        this.end();
    }

    public static <I> void writeAny(FiniteAlphabetAutomaton<?, I, ?> automaton, Appendable out) throws IOException {
        TAFWriter.writeAny(automaton, automaton.getInputAlphabet(), out);
    }

    public static <I> void writeAny(Automaton<?, I, ?> automaton, Collection<? extends I> inputs, Appendable out) throws IOException {
        if (automaton instanceof DFA) {
            TAFWriter.writeDFA((DFA)automaton, inputs, out);
        } else if (automaton instanceof MealyMachine) {
            TAFWriter.writeMealy((MealyMachine)automaton, inputs, out);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static <S, I> void writeDFA(DFA<S, I> dfa, Collection<? extends I> inputs, Appendable out) throws IOException {
        TAFWriter writer = new TAFWriter(out);
        writer.doWriteAutomaton(dfa, inputs, "dfa", s -> dfa.isAccepting(s) ? Collections.singleton("accepting") : Collections.emptySet());
    }

    public static <I> void writeMealy(MealyMachine<?, I, ?, ?> mealy, Collection<? extends I> inputs, Appendable out) throws IOException {
        TAFWriter writer = new TAFWriter(out);
        writer.doWriteAutomaton(mealy, inputs, "mealy", s -> Collections.emptySet());
    }

    public static <I> void dfaToString(DFA<?, I> dfa, Collection<? extends I> inputs) {
        try {
            StringBuilder sb = new StringBuilder();
            TAFWriter.writeDFA(dfa, inputs, sb);
        }
        catch (IOException ex) {
            throw new AssertionError();
        }
    }

    public static <I> void writeDFA(DFA<?, I> dfa, Collection<? extends I> inputs, File out) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(out));){
            TAFWriter.writeDFA(dfa, inputs, bw);
        }
    }

    public static <I> void writeMealy(MealyMachine<?, I, ?, ?> mealy, Collection<? extends I> inputs, File out) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(out));){
            TAFWriter.writeMealy(mealy, inputs, bw);
        }
    }

    public static <I> void mealyToString(MealyMachine<?, I, ?, ?> mealy, Collection<? extends I> inputs) {
        try {
            StringBuilder sb = new StringBuilder();
            TAFWriter.writeMealy(mealy, inputs, sb);
        }
        catch (IOException ex) {
            throw new AssertionError();
        }
    }
}

