/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.tools.taf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.serialization.taf.parser.PrintStreamDiagnosticListener;
import net.automatalib.serialization.taf.parser.TAFParser;
import net.automatalib.visualization.Visualization;

public class TAFViz {
    private void loadAndVisualize(InputStream is) {
        FiniteAlphabetAutomaton<?, String, ?> automaton = TAFParser.parseAny(is, PrintStreamDiagnosticListener.getStderrDiagnosticListener());
        Visualization.visualizeAutomaton(automaton, automaton.getInputAlphabet(), false, new GraphDOTHelper[0]);
    }

    public int run(String[] args) {
        if (args.length == 0) {
            this.loadAndVisualize(System.in);
        }
        for (String arg : args) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(arg)));){
                this.loadAndVisualize(is);
            }
            catch (FileNotFoundException ex) {
                System.err.println("Error opening file " + arg + ": " + ex.getMessage());
            }
            catch (IOException ex) {
                System.err.println("Error reading file " + arg + ": " + ex.getMessage());
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        TAFViz app = new TAFViz();
        app.run(args);
    }
}

