/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.simple.SimpleDTS;

@ParametersAreNonnullByDefault
public interface DeterministicTransitionSystem<S, I, T>
extends TransitionSystem<S, I, T>,
SimpleDTS<S, I> {
    @Nonnull
    public static <T> Set<T> transToSet(T trans) {
        if (trans == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(trans);
    }

    @Override
    @Nonnull
    default public Collection<? extends T> getTransitions(S state, I input) {
        return DeterministicTransitionSystem.transToSet(this.getTransition(state, input));
    }

    @Override
    @Nullable
    default public S getSuccessor(S state, I input) {
        T trans = this.getTransition(state, input);
        if (trans == null) {
            return null;
        }
        return this.getSuccessor(trans);
    }

    @Override
    @Nonnull
    default public Set<? extends S> getSuccessors(S state, I input) {
        return SimpleDTS.super.getSuccessors(state, input);
    }

    @Nullable
    public T getTransition(S var1, @Nullable I var2);
}

