/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.ts.PowersetViewTS;
import net.automatalib.ts.powerset.DirectPowersetDTS;
import net.automatalib.ts.simple.SimpleTS;

@ParametersAreNonnullByDefault
public interface TransitionSystem<S, I, T>
extends SimpleTS<S, I> {
    @Override
    @Nonnull
    default public Set<? extends S> getSuccessors(S state, @Nullable I input) {
        Collection<T> transitions = this.getTransitions(state, input);
        if (transitions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<S> result = new HashSet<S>(transitions.size());
        for (T trans : transitions) {
            result.add(this.getSuccessor(trans));
        }
        return result;
    }

    @Nonnull
    public Collection<? extends T> getTransitions(S var1, @Nullable I var2);

    @Nonnull
    public S getSuccessor(T var1);

    @Nonnull
    default public PowersetViewTS<?, I, ?, S, T> powersetView() {
        return new DirectPowersetDTS(this);
    }
}

