/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.powerset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.ts.PowersetViewTS;
import net.automatalib.ts.TransitionSystem;

public class DirectPowersetDTS<S, I, T>
implements PowersetViewTS<Set<? extends S>, I, Set<? extends T>, S, T> {
    private final TransitionSystem<S, I, T> ts;

    public DirectPowersetDTS(TransitionSystem<S, I, T> ts) {
        this.ts = ts;
    }

    @Override
    public Set<? extends S> getInitialState() {
        return this.ts.getInitialStates();
    }

    @Override
    public Set<? extends T> getTransition(Set<? extends S> state, I input) {
        HashSet<T> result = new HashSet<T>();
        for (S s : state) {
            Collection<T> transitions = this.ts.getTransitions(s, input);
            result.addAll(transitions);
        }
        return result;
    }

    @Override
    public Set<? extends S> getSuccessor(Set<? extends T> transition) {
        HashSet<S> result = new HashSet<S>();
        for (T trans : transition) {
            result.add(this.ts.getSuccessor(trans));
        }
        return result;
    }

    @Override
    public Set<? extends S> getSuccessor(Set<? extends S> state, I input) {
        HashSet<S> result = new HashSet<S>();
        for (S s : state) {
            Collection<T> transitions = this.ts.getTransitions(s, input);
            for (T t : transitions) {
                result.add(this.ts.getSuccessor(t));
            }
        }
        return result;
    }

    @Override
    public Collection<? extends S> getOriginalStates(Set<? extends S> state) {
        return state;
    }

    @Override
    public Collection<? extends T> getOriginalTransitions(Set<? extends T> transition) {
        return transition;
    }
}

