/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.simple;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.ts.simple.SimpleTS;

@ParametersAreNonnullByDefault
public interface SimpleDTS<S, I>
extends SimpleTS<S, I> {
    public static <S> Set<S> stateToSet(S state) {
        if (state == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(state);
    }

    @Override
    default public Set<? extends S> getInitialStates() {
        return SimpleDTS.stateToSet(this.getInitialState());
    }

    @Override
    @Nonnull
    default public Set<? extends S> getSuccessors(S state, @Nullable I input) {
        return SimpleDTS.stateToSet(this.getSuccessor(state, input));
    }

    @Override
    @Nonnull
    default public Set<? extends S> getSuccessors(S state, Iterable<? extends I> input) {
        return SimpleDTS.stateToSet(this.getSuccessor(state, input));
    }

    @Override
    @Nonnull
    default public Set<? extends S> getStates(Iterable<? extends I> input) {
        return SimpleDTS.stateToSet(this.getState(input));
    }

    @Nullable
    public S getInitialState();

    @Nullable
    public S getSuccessor(S var1, @Nullable I var2);

    @Nullable
    default public S getSuccessor(S state, Iterable<? extends I> input) {
        S curr = state;
        Iterator<I> it = input.iterator();
        while (curr != null && it.hasNext()) {
            I sym = it.next();
            curr = this.getSuccessor(curr, sym);
        }
        return curr;
    }

    @Nullable
    default public S getState(Iterable<? extends I> input) {
        return this.getSuccessor(this.getInitialState(), input);
    }
}

