/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.simple;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.commons.util.mappings.MapMapping;
import net.automatalib.commons.util.mappings.MutableMapping;

@ParametersAreNonnullByDefault
public interface SimpleTS<S, I> {
    @Nonnull
    public Set<? extends S> getInitialStates();

    @Nonnull
    public Set<? extends S> getSuccessors(S var1, @Nullable I var2);

    @Nonnull
    default public Set<? extends S> getSuccessors(S state, Iterable<? extends I> input) {
        return this.getSuccessors((Collection<? extends S>)Collections.singleton(state), input);
    }

    @Nonnull
    default public Set<? extends S> getSuccessors(Collection<? extends S> states, Iterable<? extends I> input) {
        HashSet<Object> current = new HashSet<S>(states);
        HashSet<Object> succs = new HashSet();
        for (I sym : input) {
            for (Object state : current) {
                Set currSuccs = this.getSuccessors(state, sym);
                succs.addAll(currSuccs);
            }
            HashSet<S> tmp = current;
            current = succs;
            succs = tmp;
            succs.clear();
        }
        return current;
    }

    @Nonnull
    default public Set<? extends S> getStates(Iterable<? extends I> input) {
        return this.getSuccessors((Collection<? extends S>)this.getInitialStates(), input);
    }

    @Nonnull
    default public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new MapMapping(new HashMap());
    }

    @Nonnull
    default public <V> MutableMapping<S, V> createDynamicStateMapping() {
        return new MapMapping(new HashMap());
    }
}

