/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.transout;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.concepts.TransitionOutput;
import net.automatalib.ts.DeterministicTransitionSystem;

@ParametersAreNonnullByDefault
public interface DeterministicTransitionOutputTS<S, I, T, O>
extends DeterministicTransitionSystem<S, I, T>,
TransitionOutput<T, O> {
    @Nullable
    default public O getOutput(S state, @Nullable I input) {
        Object trans = this.getTransition(state, input);
        if (trans == null) {
            return null;
        }
        return this.getTransitionOutput(trans);
    }

    default public boolean trace(Iterable<? extends I> input, List<? super O> output) {
        return this.trace(this.getInitialState(), input, output);
    }

    default public boolean trace(S state, Iterable<? extends I> input, List<? super O> output) {
        for (I sym : input) {
            Object trans = this.getTransition(state, sym);
            if (trans == null) {
                return false;
            }
            Object out = this.getTransitionOutput(trans);
            output.add(out);
            state = this.getSuccessor(trans);
        }
        return true;
    }
}

