/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.words.Word;

class Covers {
    Covers() {
    }

    public static <S, I, T> void cover(DeterministicAutomaton<S, I, T> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> states, Collection<? super Word<I>> transitions) {
        Object curr;
        MutableMapping reach = automaton.createStaticStateMapping();
        ArrayDeque<Object> bfsQueue = new ArrayDeque<Object>();
        Object init = automaton.getInitialState();
        reach.put(init, Word.epsilon());
        bfsQueue.add(init);
        if (states != null) {
            states.add(Word.epsilon());
        }
        while ((curr = bfsQueue.poll()) != null) {
            Word as = (Word)reach.get(curr);
            for (I in : inputs) {
                Object succ = automaton.getSuccessor(curr, in);
                if (succ == null) continue;
                if (reach.get(succ) == null) {
                    Word<I> succAs = as.append(in);
                    reach.put(succ, succAs);
                    if (states != null) {
                        states.add(succAs);
                    }
                    bfsQueue.add(succ);
                    continue;
                }
                if (transitions == null) continue;
                transitions.add(as.append(in));
            }
        }
    }

    public static <S, I, T> boolean incrementalStateCover(DeterministicAutomaton<S, I, T> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldStates, Collection<? super Word<I>> newStates) {
        Record curr;
        Object state;
        MutableMapping reach = automaton.createStaticStateMapping();
        boolean augmented = false;
        ArrayDeque bfsQueue = new ArrayDeque();
        for (Word<I> oldStateAs : oldStates) {
            state = automaton.getState(oldStateAs);
            if (state == null || reach.get(state) != null) continue;
            Record rec = new Record(state, oldStateAs);
            reach.put(state, rec);
            bfsQueue.add(rec);
        }
        Object init = automaton.getInitialState();
        if (reach.get(init) == null) {
            Record rec = new Record(init, Word.epsilon());
            reach.put(init, rec);
            bfsQueue.add(rec);
            newStates.add(Word.epsilon());
            augmented = true;
        }
        while ((curr = (Record)bfsQueue.poll()) != null) {
            state = curr.state;
            Word as = curr.accessSequence;
            for (I in : inputs) {
                Object succ = automaton.getSuccessor(state, in);
                if (succ == null || reach.get(succ) != null) continue;
                Word<I> succAs = as.append(in);
                Record succRec = new Record(succ, succAs);
                reach.put(succ, succRec);
                bfsQueue.add(succRec);
                newStates.add(succAs);
                augmented = true;
            }
        }
        return augmented;
    }

    public static <S, I, T> boolean incrementalCover(DeterministicAutomaton<S, I, T> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldStateCover, Collection<? extends Word<I>> oldTransCover, Collection<? super Word<I>> newStateCover, Collection<? super Word<I>> newTransCover) {
        Record record;
        Word[] oldTransCoverArray;
        MutableMapping reach = automaton.createStaticStateMapping();
        boolean augmented = false;
        ArrayDeque bfsQueue = new ArrayDeque();
        Object init = automaton.getInitialState();
        Record initRec = new Record(init, Word.epsilon(), new HashSet());
        bfsQueue.add(initRec);
        reach.put(init, initRec);
        boolean hasEpsilon = false;
        for (Word<I> word : oldStateCover) {
            Object state = automaton.getState(word);
            if (state == null || reach.get(state) != null) {
                if (!word.isEmpty()) continue;
                hasEpsilon = true;
                continue;
            }
            Record rec = new Record(state, word, new HashSet());
            bfsQueue.add(rec);
            reach.put(state, rec);
        }
        for (Word<I> word : oldStateCover) {
            if (word.isEmpty()) continue;
            Word<I> asPrefix = word.prefix(word.length() - 1);
            Object pred = automaton.getState(asPrefix);
            assert (pred != null);
            Record predRec = (Record)reach.get(pred);
            if (predRec == null) {
                throw new IllegalArgumentException("State cover was not prefix-closed: prefix of " + word + " not in set");
            }
            I lastSym = word.lastSymbol();
            predRec.coveredInputs.add(lastSym);
        }
        Word[] wordArray = oldTransCoverArray = oldTransCover.isEmpty() ? null : oldTransCover.toArray(new Word[oldTransCover.size()]);
        if (!hasEpsilon && newStateCover != null) {
            newStateCover.add(Word.epsilon());
            augmented = true;
        }
        if (oldTransCoverArray != null) {
            for (Word oldTransAs : oldTransCoverArray) {
                Word predAs;
                Object pred;
                Record rec;
                Object state = automaton.getState(oldTransAs);
                if (state != null && (rec = (Record)reach.get(state)) == null) {
                    rec = new Record(state, oldTransAs, new HashSet());
                    bfsQueue.add(rec);
                    reach.put(state, rec);
                    if (newStateCover != null) {
                        newStateCover.add(oldTransAs);
                        augmented = true;
                    }
                }
                if ((pred = automaton.getState(predAs = oldTransAs.prefix(oldTransAs.length() - 1))) == null) {
                    throw new IllegalArgumentException("Invalid transition: prefix of transition " + oldTransAs + " not covered by state cover");
                }
                Object lastSym = oldTransAs.lastSymbol();
                Record predRec = (Record)reach.get(pred);
                predRec.coveredInputs.add(lastSym);
            }
        }
        while ((record = (Record)bfsQueue.poll()) != null) {
            for (I input : inputs) {
                if (!record.coveredInputs.add(input)) continue;
                Object succ = automaton.getSuccessor(record.state, input);
                Word<I> newAs = record.accessSequence.append(input);
                if (succ == null) {
                    if (newTransCover == null) continue;
                    newTransCover.add(newAs);
                    augmented = true;
                    continue;
                }
                Record<Object, I> succRec = (Record<Object, I>)reach.get(succ);
                if (succRec == null) {
                    succRec = new Record<Object, I>(succ, newAs, new HashSet());
                    bfsQueue.add(succRec);
                    reach.put(succ, succRec);
                    if (newStateCover == null) continue;
                    newStateCover.add(newAs);
                    augmented = true;
                    continue;
                }
                if (newTransCover == null) continue;
                newTransCover.add(newAs);
                augmented = true;
            }
        }
        return augmented;
    }

    private static final class Record<S, I> {
        private final S state;
        private final Word<I> accessSequence;
        private final Set<I> coveredInputs;

        public Record(S state, Word<I> accessSequence) {
            this(state, accessSequence, null);
        }

        public Record(S state, Word<I> accessSequence, Set<I> coveredInputs) {
            this.state = state;
            this.accessSequence = accessSequence;
            this.coveredInputs = coveredInputs;
        }
    }
}

