/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.asgraph;

import java.util.Collection;
import java.util.Iterator;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.util.automata.asgraph.AGHelper;

public class AutomatonAsGraph<S, I, T, A extends Automaton<S, I, T>>
implements Graph<S, TransitionEdge<I, T>> {
    protected final A automaton;
    protected final Collection<? extends I> inputAlphabet;

    public AutomatonAsGraph(A automaton, Collection<? extends I> inputAlphabet) {
        this.automaton = automaton;
        this.inputAlphabet = inputAlphabet;
    }

    @Override
    public Iterator<S> iterator() {
        return this.automaton.iterator();
    }

    @Override
    public Collection<S> getNodes() {
        return this.automaton.getStates();
    }

    @Override
    public Collection<TransitionEdge<I, T>> getOutgoingEdges(S node) {
        return AGHelper.outgoingEdges(this.automaton, node, this.inputAlphabet);
    }

    @Override
    public S getTarget(TransitionEdge<I, T> edge) {
        return this.automaton.getSuccessor(edge.getTransition());
    }

    @Override
    public int size() {
        return this.automaton.size();
    }

    @Override
    public <V> MutableMapping<S, V> createStaticNodeMapping() {
        return this.automaton.createStaticStateMapping();
    }

    @Override
    public <V> MutableMapping<S, V> createDynamicNodeMapping() {
        return this.automaton.createDynamicStateMapping();
    }

    @Override
    public NodeIDs<S> nodeIDs() {
        final StateIDs stateIds = this.automaton.stateIDs();
        return new NodeIDs<S>(){

            @Override
            public int getNodeId(S node) {
                return stateIds.getStateId(node);
            }

            @Override
            public S getNode(int id) {
                return stateIds.getState(id);
            }
        };
    }
}

