/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.conformance;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.conformance.StrictPriorityQueue;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class IncrementalWMethodTestsIterator<I>
implements Iterator<Word<I>> {
    private final Alphabet<I> alphabet;
    private final StrictPriorityQueue<Item<I>> itemQueue;
    private int maxDepth;
    private final List<Word<I>> prefixes = new ArrayList<Word<I>>();
    private final List<Word<I>> suffixes = new ArrayList<Word<I>>();

    public IncrementalWMethodTestsIterator(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.itemQueue = new StrictPriorityQueue<I>(new ItemComparator<I>(alphabet), new ItemMerge());
        this.suffixes.add(Word.epsilon());
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    private Word<I> startMiddleWord() {
        return Word.fromLetter(this.alphabet.getSymbol(0));
    }

    public void update(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton) {
        Item item;
        int oldNumPrefixes = this.prefixes.size();
        boolean newPrefixes = Automata.incrementalStructuralCover(automaton, this.alphabet, this.prefixes, this.prefixes);
        int oldNumSuffixes = this.suffixes.size();
        boolean newSuffixes = Automata.incrementalCharacterizingSet(automaton, this.alphabet, this.suffixes, this.suffixes);
        if (newSuffixes && oldNumPrefixes > 0) {
            item = new Item();
            item.prefixIdx = 0;
            item.minPrefix = 0;
            item.maxPrefix = oldNumPrefixes;
            item.suffixIdx = oldNumSuffixes;
            item.minSuffix = oldNumSuffixes;
            item.middle = this.startMiddleWord();
            this.itemQueue.insert(item);
        }
        if (newPrefixes) {
            item = new Item();
            item.prefixIdx = oldNumPrefixes;
            item.minPrefix = oldNumPrefixes;
            item.maxPrefix = this.prefixes.size();
            item.suffixIdx = 0;
            item.minSuffix = 0;
            item.middle = this.startMiddleWord();
            this.itemQueue.insert(item);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.itemQueue.isEmpty();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Word<I> next() {
        Item<I> nextItem = this.itemQueue.extractMin();
        Word<I> result = this.assembleWord(nextItem);
        Item<I> inc = this.increment(nextItem);
        if (inc != null) {
            this.itemQueue.insert(inc);
        }
        return result;
    }

    private Item<I> increment(Item<I> item) {
        ((Item)item).suffixIdx++;
        if (((Item)item).suffixIdx >= this.suffixes.size()) {
            ((Item)item).suffixIdx = ((Item)item).minSuffix;
            ((Item)item).prefixIdx++;
            if (((Item)item).prefixIdx >= ((Item)item).maxPrefix) {
                ((Item)item).prefixIdx = ((Item)item).minPrefix;
                ((Item)item).middle = ((Item)item).middle.canonicalNext(this.alphabet);
                if (((Item)item).middle.length() > this.maxDepth) {
                    return null;
                }
            }
        }
        return item;
    }

    private Word<I> assembleWord(Item<I> item) {
        Word<I> prefix = this.prefixes.get(((Item)item).prefixIdx);
        Word<I> suffix = this.suffixes.get(((Item)item).suffixIdx);
        return prefix.concat(((Item)item).middle, suffix);
    }

    private static final class ItemComparator<I>
    implements Comparator<Item<? extends I>> {
        private final Comparator<? super Word<? extends I>> canonicalCmp;

        public ItemComparator(Comparator<? super I> symComparator) {
            this.canonicalCmp = Word.canonicalComparator(symComparator);
        }

        @Override
        public int compare(Item<? extends I> o1, Item<? extends I> o2) {
            int cmp = this.canonicalCmp.compare(((Item)o1).middle, ((Item)o2).middle);
            if (cmp != 0) {
                return cmp;
            }
            cmp = ((Item)o1).prefixIdx - ((Item)o2).prefixIdx;
            if (cmp != 0) {
                return cmp;
            }
            return ((Item)o1).suffixIdx - ((Item)o2).suffixIdx;
        }
    }

    private static final class ItemMerge<I>
    implements StrictPriorityQueue.MergeOperation<Item<I>> {
        private ItemMerge() {
        }

        @Override
        public Item<I> merge(Item<I> oldObject, Item<I> newObject) {
            ((Item)oldObject).minSuffix = Math.min(((Item)oldObject).minSuffix, ((Item)newObject).minSuffix);
            ((Item)oldObject).minPrefix = Math.min(((Item)oldObject).minPrefix, ((Item)newObject).minPrefix);
            ((Item)oldObject).maxPrefix = Math.max(((Item)oldObject).maxPrefix, ((Item)newObject).maxPrefix);
            return oldObject;
        }
    }

    private static final class Item<I> {
        private int prefixIdx;
        private int suffixIdx;
        private Word<I> middle;
        private int minSuffix;
        private int minPrefix;
        private int maxPrefix;

        private Item() {
        }

        public String toString() {
            return Integer.toString(this.prefixIdx) + " | " + this.middle + " | " + Integer.toString(this.suffixIdx);
        }
    }
}

