/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.conformance;

import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.automatalib.commons.util.array.ResizingObjectArray;

public class StrictPriorityQueue<E>
extends AbstractQueue<E> {
    private final ResizingObjectArray storage = new ResizingObjectArray();
    private int size = 0;
    private final Comparator<? super E> comparator;
    private final MergeOperation<E> mergeOp;

    public StrictPriorityQueue(Comparator<? super E> comparator, MergeOperation<E> mergeOp) {
        this.comparator = comparator;
        this.mergeOp = mergeOp;
    }

    public boolean insert(E object) {
        this.storage.ensureCapacity(this.size + 1);
        this.storage.array[this.size++] = object;
        if (!this.upHeap()) {
            --this.size;
            return false;
        }
        return true;
    }

    public E peekMin() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.storage.array[0];
    }

    public E extractMin() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Object result = this.storage.array[0];
        --this.size;
        if (this.size > 0) {
            this.storage.array[0] = this.storage.array[this.size];
            this.downHeap();
        }
        this.storage.array[this.size] = 0;
        return (E)result;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.storage.array[0]);
        for (int i = 1; i < this.size; ++i) {
            result.append(',');
            result.append(this.storage.array[i]);
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public boolean offer(E e) {
        return this.insert(e);
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        return this.extractMin();
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.storage.array[0];
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < StrictPriorityQueue.this.size;
            }

            @Override
            public E next() {
                return ((StrictPriorityQueue)StrictPriorityQueue.this).storage.array[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    private void downHeap() {
        Object elem = this.storage.array[0];
        int currIdx = 0;
        while (2 * currIdx < this.size) {
            int leftChildIdx = 2 * currIdx;
            Object leftChild = this.storage.array[leftChildIdx];
            if (this.comparator.compare(elem, leftChild) > 0) {
                this.storage.array[currIdx] = leftChild;
                this.storage.array[leftChildIdx] = elem;
                currIdx = leftChildIdx;
                continue;
            }
            if (2 * currIdx + 1 < this.size) {
                int rightChildIdx = 2 * currIdx + 1;
                Object rightChild = this.storage.array[rightChildIdx];
                if (this.comparator.compare(elem, rightChild) > 0) {
                    this.storage.array[currIdx] = rightChild;
                    this.storage.array[rightChildIdx] = elem;
                    currIdx = rightChildIdx;
                    continue;
                }
                return;
            }
            return;
        }
    }

    private boolean upHeap() {
        int currIdx = this.size - 1;
        Object elem = this.storage.array[currIdx];
        int steps = 0;
        while (currIdx > 0) {
            int parentIdx = currIdx / 2;
            Object parent = this.storage.array[parentIdx];
            int cmp = this.comparator.compare(elem, parent);
            if (cmp == 0) {
                this.storage.array[parentIdx] = this.mergeOp.merge(parent, elem);
                return false;
            }
            if (cmp > 0) break;
            currIdx = parentIdx;
            ++steps;
        }
        currIdx = this.size - 1;
        for (int i = 0; i < steps; ++i) {
            int parentIdx = currIdx / 2;
            this.storage.array[currIdx] = this.storage.array[parentIdx];
            currIdx = parentIdx;
        }
        this.storage.array[currIdx] = elem;
        return true;
    }

    public static interface MergeOperation<E> {
        public E merge(E var1, E var2);
    }
}

