/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.equivalence;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Word;

public class CharacterizingSets {
    private static <S, I, T> List<Object> buildTrace(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, S state, Word<I> suffix) {
        I sym;
        Object trans;
        if (suffix.isEmpty()) {
            Object prop = automaton.getStateProperty(state);
            return Collections.singletonList(prop);
        }
        ArrayList<Object> trace = new ArrayList<Object>(2 * suffix.length());
        S curr = state;
        Iterator<I> iterator = suffix.iterator();
        while (iterator.hasNext() && (trans = automaton.getTransition(curr, sym = iterator.next())) != null) {
            Object prop = automaton.getTransitionProperty(trans);
            trace.add(prop);
            curr = automaton.getSuccessor(trans);
            prop = automaton.getStateProperty(curr);
            trace.add(prop);
        }
        return trace;
    }

    private static <S, I, T> boolean checkTrace(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, S state, Word<I> suffix, List<Object> trace) {
        Iterator<Object> it = trace.iterator();
        S curr = state;
        for (I sym : suffix) {
            Object trans = automaton.getTransition(curr, sym);
            if (!it.hasNext()) {
                return trans == null;
            }
            Object prop = automaton.getTransitionProperty(trans);
            if (!Objects.equals(prop, it.next())) {
                return false;
            }
            curr = automaton.getSuccessor(trans);
            prop = automaton.getStateProperty(curr);
            if (Objects.equals(prop, it.next())) continue;
            return false;
        }
        return true;
    }

    private static <S, I, T> List<List<Object>> buildSignature(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, List<? extends Word<I>> suffixes, S state) {
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(suffixes.size());
        for (Word<I> suffix : suffixes) {
            List<Object> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            signature.add(trace);
        }
        return signature;
    }

    private static <S, I, T> void cluster(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Word<I> suffix, Iterator<S> stateIt, Map<List<Object>, List<S>> bucketMap) {
        while (stateIt.hasNext()) {
            S state = stateIt.next();
            List<Object> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            List<S> bucket = bucketMap.get(trace);
            if (bucket == null) {
                bucket = new ArrayList<S>();
                bucketMap.put(trace, bucket);
            }
            bucket.add(state);
        }
    }

    public static <S, I, T> void findCharacterizingSet(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Collection<? extends I> inputs, S state, Collection<? super Word<I>> result) {
        Object prop = automaton.getStateProperty(state);
        ArrayList currentBlock = new ArrayList();
        boolean multipleStateProps = false;
        for (Object s : automaton) {
            if (Objects.equals(s, state)) continue;
            Object sProp = automaton.getStateProperty(s);
            if (!Objects.equals(sProp, prop)) {
                multipleStateProps = true;
                continue;
            }
            currentBlock.add(s);
        }
        if (multipleStateProps) {
            result.add(Word.epsilon());
        }
        while (!currentBlock.isEmpty()) {
            ArrayList nextBlock = new ArrayList();
            Iterator it = currentBlock.iterator();
            Word<? extends I> suffix = null;
            while (it.hasNext() && suffix == null) {
                Object s = it.next();
                suffix = Automata.findSeparatingWord(automaton, state, s, inputs);
            }
            if (suffix == null) {
                return;
            }
            result.add(suffix);
            List<Object> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            while (it.hasNext()) {
                Object s = it.next();
                if (!CharacterizingSets.checkTrace(automaton, s, suffix, trace)) continue;
                nextBlock.add(s);
            }
            currentBlock = nextBlock;
        }
    }

    public static <S, I, T> void findCharacterizingSet(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> result) {
        CharacterizingSets.findIncrementalCharacterizingSet(automaton, inputs, Collections.emptyList(), result);
    }

    private static <S, I, T> Map<Object, List<S>> clusterByProperty(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, List<S> states) {
        HashMap<Object, List<S>> result = new HashMap<Object, List<S>>();
        for (S state : states) {
            Object prop = automaton.getStateProperty(state);
            ArrayList<S> block = (ArrayList<S>)result.get(prop);
            if (block == null) {
                block = new ArrayList<S>();
                result.put(prop, block);
            }
            block.add(state);
        }
        return result;
    }

    private static <S, I, T> boolean epsilonRefine(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Queue<List<S>> blockQueue) {
        int initialSize = blockQueue.size();
        boolean refined = false;
        for (int i = 0; i < initialSize; ++i) {
            List<S> block = blockQueue.poll();
            if (block.size() <= 1) continue;
            Map<Object, List<S>> propCluster = CharacterizingSets.clusterByProperty(automaton, block);
            if (propCluster.size() > 1) {
                refined = true;
            }
            blockQueue.addAll(propCluster.values());
        }
        return refined;
    }

    private static <S, I, T> Word<I> refine(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Collection<? extends I> inputs, Queue<List<S>> blockQueue) {
        List<S> currBlock;
        while ((currBlock = blockQueue.poll()) != null) {
            if (currBlock.size() <= 1) continue;
            Iterator<S> it = currBlock.iterator();
            S ref = it.next();
            Word<? extends I> suffix = null;
            S state = null;
            while (it.hasNext() && suffix == null) {
                state = it.next();
                suffix = Automata.findSeparatingWord(automaton, ref, state, inputs);
            }
            if (suffix == null) continue;
            int otherBlocks = blockQueue.size();
            HashMap<List<Object>, List<S>> buckets = new HashMap<List<Object>, List<S>>();
            ArrayList<S> firstBucket = new ArrayList<S>();
            ArrayList<S> secondBucket = new ArrayList<S>();
            firstBucket.add(ref);
            buckets.put(CharacterizingSets.buildTrace(automaton, ref, suffix), firstBucket);
            secondBucket.add(state);
            buckets.put(CharacterizingSets.buildTrace(automaton, state, suffix), secondBucket);
            CharacterizingSets.cluster(automaton, suffix, it, buckets);
            blockQueue.addAll(buckets.values());
            for (int i = 0; i < otherBlocks; ++i) {
                List<S> otherBlock = blockQueue.poll();
                if (otherBlock.size() <= 2) continue;
                buckets.clear();
                CharacterizingSets.cluster(automaton, suffix, otherBlock.iterator(), buckets);
                blockQueue.addAll(buckets.values());
            }
            return suffix;
        }
        return null;
    }

    public static <S, I, T> boolean findIncrementalCharacterizingSet(UniversalDeterministicAutomaton<S, I, T, ?, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldSuffixes, Collection<? super Word<I>> newSuffixes) {
        Word<? extends I> suffix;
        boolean refined = false;
        HashMap initialPartitioning = new HashMap();
        ArrayList<Word<I>> oldSuffixList = oldSuffixes instanceof List ? (ArrayList<Word<I>>)oldSuffixes : new ArrayList<Word<I>>(oldSuffixes);
        ArrayDeque<List<S>> blocks = new ArrayDeque<List<S>>();
        for (Object state : automaton) {
            List<List<Object>> sig = CharacterizingSets.buildSignature(automaton, oldSuffixList, state);
            ArrayList block = (ArrayList)initialPartitioning.get(sig);
            if (block == null) {
                block = new ArrayList();
                blocks.add(block);
                initialPartitioning.put(sig, block);
            }
            block.add(state);
        }
        if (!oldSuffixes.contains(Word.epsilon()) && CharacterizingSets.epsilonRefine(automaton, blocks)) {
            newSuffixes.add(Word.epsilon());
            refined = true;
        }
        while ((suffix = CharacterizingSets.refine(automaton, inputs, blocks)) != null) {
            newSuffixes.add(suffix);
            refined = true;
        }
        return refined;
    }
}

