/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.fsa;

import java.util.Collection;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.util.automata.Automata;

public abstract class MutableDFAs {
    public static <S, I> void complete(MutableDFA<S, I> dfa, Collection<? extends I> inputs) {
        MutableDFAs.complete(dfa, inputs, false);
    }

    public static <S, I> void complete(MutableDFA<S, I> dfa, Collection<? extends I> inputs, boolean minimize) {
        MutableDFAs.complete(dfa, inputs, minimize, false);
    }

    public static <S, I> void complete(MutableDFA<S, I> dfa, Collection<? extends I> inputs, boolean minimize, boolean undefinedAcceptance) {
        Object sink = null;
        for (Object state : dfa) {
            for (I input : inputs) {
                Object succ = dfa.getSuccessor(state, input);
                if (succ != null) continue;
                if (sink == null) {
                    sink = dfa.addState(undefinedAcceptance);
                    for (I inputSym : inputs) {
                        dfa.addTransition(sink, inputSym, sink);
                    }
                }
                dfa.addTransition(state, input, sink);
            }
        }
        if (minimize) {
            Automata.invasiveMinimize(dfa, inputs);
        }
    }

    public static <S, I> void complement(MutableDFA<S, I> dfa, Collection<? extends I> inputs) {
        dfa.flipAcceptance();
        MutableDFAs.complete(dfa, inputs, false, true);
    }

    private MutableDFAs() {
        throw new IllegalStateException("Constructor should never be invoked");
    }
}

