/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.random;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.random.RandomUtil;
import net.automatalib.words.Alphabet;

@ParametersAreNonnullByDefault
public class RandomICAutomatonGenerator<SP, TP> {
    @Nonnull
    private Function<? super Random, ? extends SP> spSupplier = r -> null;
    @Nonnull
    private Function<? super Random, ? extends TP> tpSupplier = r -> null;

    public static RandomICAutomatonGenerator<Boolean, Void> forDFA() {
        return new RandomICAutomatonGenerator().withStateProperties((? super Random r) -> r.nextBoolean());
    }

    public static RandomICAutomatonGenerator<Boolean, Void> forDFA(double acceptingRatio) {
        return new RandomICAutomatonGenerator().withStateProperties((? super Random r) -> r.nextDouble() < acceptingRatio);
    }

    public RandomICAutomatonGenerator<SP, TP> withStateProperties(Supplier<? extends SP> spSupplier) {
        return this.withStateProperties((? super Random r) -> spSupplier.get());
    }

    public RandomICAutomatonGenerator<SP, TP> withStateProperties(Function<? super Random, ? extends SP> spFunc) {
        this.spSupplier = Objects.requireNonNull(spFunc);
        return this;
    }

    public RandomICAutomatonGenerator<SP, TP> withStateProperties(Collection<? extends SP> possibleSps) {
        if (possibleSps.isEmpty()) {
            return this.withStateProperties((? super Random r) -> null);
        }
        ArrayList spList = new ArrayList(possibleSps);
        return this.withStateProperties((? super Random r) -> RandomUtil.choose(spList, r));
    }

    @SafeVarargs
    public final RandomICAutomatonGenerator<SP, TP> withStateProperties(SP ... possibleSps) {
        if (possibleSps.length == 0) {
            return this.withStateProperties((? super Random r) -> null);
        }
        return this.withStateProperties((? super Random r) -> RandomUtil.choose(possibleSps, r));
    }

    public RandomICAutomatonGenerator<SP, TP> withTransitionProperties(Supplier<? extends TP> tpSupplier) {
        return this.withTransitionProperties((? super Random r) -> tpSupplier.get());
    }

    public RandomICAutomatonGenerator<SP, TP> withTransitionProperties(Function<? super Random, ? extends TP> tpFunc) {
        this.tpSupplier = Objects.requireNonNull(tpFunc);
        return this;
    }

    public RandomICAutomatonGenerator<SP, TP> withTransitionProperties(Collection<? extends TP> possibleTps) {
        if (possibleTps.isEmpty()) {
            return this.withTransitionProperties((? super Random r) -> null);
        }
        ArrayList tpList = new ArrayList(possibleTps);
        return this.withTransitionProperties((? super Random r) -> RandomUtil.choose(tpList, r));
    }

    @SafeVarargs
    public final RandomICAutomatonGenerator<SP, TP> withTransitionProperties(TP ... possibleTps) {
        if (possibleTps.length == 0) {
            return this.withTransitionProperties((? super Random r) -> null);
        }
        return this.withTransitionProperties((Collection<? extends TP>)Arrays.asList(possibleTps));
    }

    public <I, A extends MutableDeterministic<?, I, ?, ? super SP, ? super TP>> A generateICDeterministicAutomaton(int numStates, Collection<? extends I> inputs, A result, Random r) {
        int i;
        UniversalDeterministicAutomaton.StateIntAbstraction resultAbs = result.stateIntAbstraction();
        List<? extends I> inputsList = CollectionsUtil.randomAccessList(inputs);
        resultAbs.addIntInitialState(this.spSupplier.apply(r));
        for (i = 1; i < numStates; ++i) {
            I input;
            int src;
            int succ;
            while ((succ = resultAbs.getSuccessor(src = r.nextInt(i), input = RandomUtil.choose(inputsList, r))) >= 0) {
            }
            int next = resultAbs.addIntState(this.spSupplier.apply(r));
            resultAbs.setTransition(src, input, next, this.tpSupplier.apply(r));
        }
        for (i = 0; i < numStates; ++i) {
            for (I input : inputs) {
                if (resultAbs.getSuccessor(i, input) >= 0) continue;
                int succ = r.nextInt(numStates);
                resultAbs.setTransition(i, input, succ, this.tpSupplier.apply(r));
            }
        }
        return result;
    }

    public <I, A extends MutableDeterministic<?, I, ?, ? super SP, ? super TP>> A generateICDeterministicAutomaton(int numStates, Alphabet<I> alphabet, AutomatonCreator<? extends A, I> creator, Random r) {
        MutableDeterministic result = (MutableDeterministic)creator.createAutomaton(alphabet, numStates);
        return (A)this.generateICDeterministicAutomaton(numStates, alphabet, result, r);
    }
}

