/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.transout;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.MutableMealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.util.automata.copy.AutomatonCopyMethod;
import net.automatalib.util.automata.copy.AutomatonLowLevelCopy;
import net.automatalib.util.automata.predicates.TransitionPredicates;
import net.automatalib.words.Alphabet;

public abstract class MealyFilter {
    @SafeVarargs
    public static <I, O> CompactMealy<I, O> pruneTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, O ... outputs) {
        return MealyFilter.pruneTransitionsWithOutput(in, inputs, Arrays.asList(outputs));
    }

    public static <I, O> CompactMealy<I, O> pruneTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, Collection<? super O> outputs) {
        return MealyFilter.filterByOutput(in, inputs, o -> !outputs.contains(o));
    }

    @SafeVarargs
    public static <I, O> CompactMealy<I, O> retainTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, O ... outputs) {
        return MealyFilter.retainTransitionsWithOutput(in, inputs, Arrays.asList(outputs));
    }

    public static <I, O> CompactMealy<I, O> retainTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, Collection<? super O> outputs) {
        return MealyFilter.filterByOutput(in, inputs, o -> outputs.contains(o));
    }

    public static <I, O> CompactMealy<I, O> filterByOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, Predicate<? super O> outputPred) {
        CompactMealy out = new CompactMealy(inputs);
        MealyFilter.filterByOutput(in, inputs, out, outputPred);
        return out;
    }

    public static <S1, T1, S2, I, O> Mapping<S1, S2> filterByOutput(MealyMachine<S1, I, T1, O> in, Collection<? extends I> inputs, MutableMealyMachine<S2, I, ?, O> out, Predicate<? super O> outputPred) {
        TransitionPredicate transPred = TransitionPredicates.outputSatisfies(in, outputPred);
        return AutomatonLowLevelCopy.copy(AutomatonCopyMethod.DFS, in, inputs, out, s -> true, transPred);
    }

    private MealyFilter() {
        throw new IllegalStateException("Constructor should never be invoked");
    }
}

