/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Predicate;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.Path;

final class FindShortestPathsIterator<N, E>
extends AbstractIterator<Path<N, E>> {
    private final Queue<N> bfsQueue = new ArrayDeque<N>();
    private final IndefiniteGraph<N, E> graph;
    private final MutableMapping<N, Pred<N, E>> preds;
    private final Predicate<? super N> targetPred;
    private final int limit;
    private int count;

    public FindShortestPathsIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, Predicate<? super N> targetPred) {
        this.graph = graph;
        this.preds = graph.createStaticNodeMapping();
        this.limit = limit;
        this.targetPred = Objects.requireNonNull(targetPred);
        for (N startNode : start) {
            this.preds.put(startNode, new Pred<Object, Object>(null, null));
            this.bfsQueue.add(startNode);
        }
    }

    protected Path<N, E> computeNext() {
        while (!this.bfsQueue.isEmpty()) {
            if (this.count++ == this.limit) {
                return (Path)this.endOfData();
            }
            N curr = this.bfsQueue.poll();
            if (this.targetPred.test(curr)) {
                return this.makePath(curr);
            }
            for (E edge : this.graph.getOutgoingEdges(curr)) {
                N tgt = this.graph.getTarget(edge);
                Pred pred = (Pred)this.preds.get(tgt);
                if (pred != null) continue;
                this.preds.put(tgt, new Pred<N, E>(curr, edge));
                this.bfsQueue.add(tgt);
            }
        }
        return (Path)this.endOfData();
    }

    private Path<N, E> makePath(N target) {
        ArrayList edges = new ArrayList();
        N currNode = target;
        Pred pred = (Pred)this.preds.get(currNode);
        while (pred != null && pred.edge != null) {
            edges.add(pred.edge);
            currNode = pred.node;
            pred = (Pred)this.preds.get(currNode);
        }
        Collections.reverse(edges);
        return new Path<N, E>(this.graph, currNode, edges);
    }

    private static final class Pred<N, E> {
        public final N node;
        public final E edge;

        public Pred(N node, E edge) {
            this.node = node;
            this.edge = edge;
        }
    }
}

