/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.BidirectionalGraph;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.graphs.UniversalIndefiniteGraph;
import net.automatalib.util.graphs.Path;
import net.automatalib.util.graphs.ShortestPaths;

public abstract class Graphs {
    public static <N, E> Mapping<N, ? extends Collection<? extends E>> incomingEdges(Graph<N, E> graph) {
        if (graph instanceof BidirectionalGraph) {
            BidirectionalGraph bdGraph = (BidirectionalGraph)graph;
            return n -> bdGraph.getIncomingEdges(n);
        }
        MutableMapping inEdgesMapping = graph.createStaticNodeMapping();
        for (Object node : graph) {
            Collection outEdges = graph.getOutgoingEdges(node);
            for (Object e : outEdges) {
                Object tgt = graph.getTarget(e);
                ArrayList inEdges = (ArrayList)inEdgesMapping.get(tgt);
                if (inEdges == null) {
                    inEdges = new ArrayList();
                    inEdgesMapping.put(tgt, inEdges);
                }
                inEdges.add(e);
            }
        }
        return inEdgesMapping;
    }

    public static <N, E> Path<N, E> findShortestPath(IndefiniteGraph<N, E> graph, int limit, N start, Collection<? extends N> targets) {
        return ShortestPaths.shortestPath(graph, start, limit, targets);
    }

    public static <N, E> Path<N, E> findShortestPath(IndefiniteGraph<N, E> graph, int limit, N start, Predicate<? super N> targetPred) {
        return ShortestPaths.shortestPath(graph, start, limit, targetPred);
    }

    @Deprecated
    public static <N, NP> Mapping<N, NP> nodeProperties(UniversalIndefiniteGraph<N, ?, NP, ?> graph) {
        return n -> graph.getNodeProperty(n);
    }

    @Deprecated
    public static <E, EP> Mapping<E, EP> edgeProperties(UniversalIndefiniteGraph<?, E, ?, EP> graph) {
        return e -> graph.getEdgeProperty(e);
    }

    private Graphs() {
    }
}

