/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.dot;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.AutomataLibSettings;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.strings.StringUtil;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.UndirectedGraph;
import net.automatalib.graphs.concepts.GraphViewable;
import net.automatalib.graphs.dot.AggregateDOTHelper;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.util.automata.Automata;

public abstract class GraphDOT {
    public static boolean isDotUsable() {
        return DOT.checkUsable();
    }

    public static <N, E> void write(GraphViewable gv, Appendable a) throws IOException {
        Graph<?, ?> graph = gv.graphView();
        GraphDOT.write(graph, a, new GraphDOTHelper[0]);
    }

    @SafeVarargs
    public static <N, E> void write(Graph<N, E> graph, Appendable a, GraphDOTHelper<N, ? super E> ... additionalHelpers) throws IOException {
        GraphDOTHelper<N, E> helper = graph.getGraphDOTHelper();
        GraphDOT.writeRaw(graph, helper, a, additionalHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, GraphDOTHelper<S, ? super TransitionEdge<I, T>> helper, Collection<? extends I> inputAlphabet, Appendable a, GraphDOTHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        Graph<S, TransitionEdge<? extends I, T>> ag = Automata.asGraph(automaton, inputAlphabet);
        GraphDOT.writeRaw(ag, helper, a, additionalHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a, GraphDOTHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        GraphDOT.write(automaton.transitionGraphView(inputAlphabet), a, additionalHelpers);
    }

    @SafeVarargs
    public static <N, E> void writeRaw(Graph<N, E> graph, GraphDOTHelper<N, ? super E> helper, Appendable a, GraphDOTHelper<N, ? super E> ... additionalHelpers) throws IOException {
        ArrayList<GraphDOTHelper<N, GraphDOTHelper<N, ? super E>>> helpers = new ArrayList<GraphDOTHelper<N, GraphDOTHelper<N, ? super E>>>(additionalHelpers.length + 1);
        helpers.add(helper);
        helpers.addAll(Arrays.asList(additionalHelpers));
        GraphDOT.writeRaw(graph, a, helpers);
    }

    public static <N, E> void writeRaw(Graph<N, E> graph, Appendable a, List<GraphDOTHelper<N, ? super E>> helpers) throws IOException {
        AggregateDOTHelper<N, ? super E> aggHelper = new AggregateDOTHelper<N, E>(helpers);
        GraphDOT.writeRaw(graph, aggHelper, a);
    }

    public static <N, E> void writeRaw(Graph<N, E> graph, GraphDOTHelper<N, ? super E> dotHelper, Appendable a) throws IOException {
        if (dotHelper == null) {
            dotHelper = new DefaultDOTHelper<N, E>();
        }
        boolean directed = true;
        if (graph instanceof UndirectedGraph) {
            directed = false;
        }
        if (directed) {
            a.append("di");
        }
        a.append("graph g {\n");
        HashMap<String, String> props = new HashMap<String, String>();
        dotHelper.getGlobalNodeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("node");
            GraphDOT.appendParams(props, a);
            a.append(";\n");
        }
        props.clear();
        dotHelper.getGlobalEdgeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("edge");
            GraphDOT.appendParams(props, a);
            a.append(";\n");
        }
        dotHelper.writePreamble(a);
        a.append('\n');
        MutableMapping nodeNames = graph.createStaticNodeMapping();
        int i = 0;
        for (Object node : graph) {
            props.clear();
            if (!dotHelper.getNodeProperties(node, props)) continue;
            String id = "s" + i++;
            a.append('\t').append(id);
            GraphDOT.appendParams(props, a);
            a.append(";\n");
            nodeNames.put(node, id);
        }
        for (Object node : graph) {
            Collection outEdges;
            String srcId = (String)nodeNames.get(node);
            if (srcId == null || (outEdges = graph.getOutgoingEdges(node)).isEmpty()) continue;
            for (Object e : outEdges) {
                Object tgt = graph.getTarget(e);
                String tgtId = (String)nodeNames.get(tgt);
                if (tgtId == null || !directed && tgtId.compareTo(srcId) < 0) continue;
                props.clear();
                if (!dotHelper.getEdgeProperties(node, e, tgt, props)) continue;
                a.append('\t').append(srcId).append(' ');
                if (directed) {
                    a.append("-> ");
                } else {
                    a.append("-- ");
                }
                a.append(tgtId);
                GraphDOT.appendParams(props, a);
                a.append(";\n");
            }
        }
        a.append('\n');
        dotHelper.writePostamble(nodeNames, a);
        a.append("}\n");
        if (a instanceof Flushable) {
            ((Flushable)((Object)a)).flush();
        }
    }

    public static <N, E> void writeToFileRaw(Graph<N, E> graph, GraphDOTHelper<N, E> dotHelper, File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            GraphDOT.writeRaw(graph, dotHelper, writer);
        }
    }

    private static void appendParams(Map<String, String> params, Appendable a) throws IOException {
        if (params == null || params.isEmpty()) {
            return;
        }
        a.append(" [");
        boolean first = true;
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                a.append(' ');
            }
            String key = e.getKey();
            String value = e.getValue();
            a.append(e.getKey()).append("=");
            if (key.equals("label") && value.toUpperCase().startsWith("<HTML>")) {
                a.append('<').append(value.substring(6)).append('>');
                continue;
            }
            StringUtil.enquote(e.getValue(), a);
        }
        a.append(']');
    }

    static {
        String dotExeName;
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String dotExePath = settings.getProperty("dot.exe.dir");
        String dotExe = dotExeName = settings.getProperty("dot.exe.name", "dot");
        if (dotExePath != null) {
            Path dotBasePath = FileSystems.getDefault().getPath(dotExePath, new String[0]);
            Path resolvedDotPath = dotBasePath.resolve(dotExeName);
            dotExe = resolvedDotPath.toString();
        }
        DOT.setDotExe(dotExe);
    }
}

