/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.traversal;

import java.util.Collection;
import java.util.Iterator;
import net.automatalib.graphs.IndefiniteGraph;

class SimpleDFRecord<N, E> {
    public final N node;
    private Iterator<? extends E> edgeIterator;

    public SimpleDFRecord(N node) {
        this.node = node;
    }

    public final boolean wasStarted() {
        return this.edgeIterator != null;
    }

    public final boolean start(IndefiniteGraph<N, E> graph) {
        if (this.edgeIterator != null) {
            return false;
        }
        Collection<E> outEdges = graph.getOutgoingEdges(this.node);
        this.edgeIterator = outEdges.iterator();
        return true;
    }

    public final boolean hasNextEdge() {
        if (this.edgeIterator == null) {
            throw new IllegalStateException("Edge iteration not yet started");
        }
        return this.edgeIterator.hasNext();
    }

    public final E nextEdge() {
        if (this.edgeIterator == null) {
            throw new IllegalStateException("Edge iteration not yet started");
        }
        return this.edgeIterator.next();
    }
}

