/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.BitSet;
import java.util.Collection;
import net.automatalib.commons.smartcollections.BasicLinkedListEntry;
import net.automatalib.commons.smartcollections.IntrusiveLinkedList;
import net.automatalib.commons.smartcollections.UnorderedCollection;
import net.automatalib.util.minimizer.State;

final class TransitionLabel<S, EP>
extends BasicLinkedListEntry<TransitionLabel<S, EP>, TransitionLabel<S, EP>> {
    private final EP originalLabel;
    private final UnorderedCollection<State<S, EP>> list = new UnorderedCollection();
    private final BitSet setContents = new BitSet();
    private final IntrusiveLinkedList<State<S, EP>> bucket = new IntrusiveLinkedList();

    public TransitionLabel(EP originalLabel) {
        this.originalLabel = originalLabel;
    }

    public IntrusiveLinkedList<State<S, EP>> getBucket() {
        return this.bucket;
    }

    public boolean addToBucket(State<S, EP> state) {
        boolean first = false;
        if (this.bucket.isEmpty()) {
            first = true;
        }
        this.bucket.pushBack(state);
        return first;
    }

    public EP getOriginalLabel() {
        return this.originalLabel;
    }

    public void clearSet() {
        this.setContents.clear();
        this.list.quickClear();
    }

    public boolean addToSet(State<S, EP> state) {
        boolean first = this.list.isEmpty();
        if (first || !this.setContents.get(state.getId())) {
            this.list.add(state);
            this.setContents.set(state.getId());
        }
        return first;
    }

    public Collection<State<S, EP>> getSet() {
        return this.list;
    }

    public String toString() {
        return this.originalLabel.toString();
    }

    @Override
    public TransitionLabel<S, EP> getElement() {
        return this;
    }
}

