/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.partitionrefinement;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Block {
    public int low;
    public int ptr = -1;
    public int high;
    protected Block nextInWorklist = null;
    protected Block nextTouched = null;
    public Block nextBlock;
    public int id;

    static Iterator<Block> blockListIterator(Block start) {
        return new BlockListIterator(start);
    }

    public Block(int low, int high, int id, Block next) {
        this.low = low;
        this.high = high;
        this.id = id;
        this.nextBlock = next;
    }

    public int size() {
        return this.high - this.low;
    }

    public boolean isEmpty() {
        return this.low >= this.high;
    }

    public Block split(int newId) {
        Block splt;
        int ptr = this.ptr;
        this.ptr = -1;
        int high = this.high;
        int ptrHighDiff = high - ptr;
        if (ptrHighDiff == 0) {
            return null;
        }
        int low = this.low;
        if (ptrHighDiff > ptr - low) {
            splt = new Block(low, ptr, newId, this.nextBlock);
            this.low = ptr;
        } else {
            splt = new Block(ptr, high, newId, this.nextBlock);
            this.high = ptr;
        }
        this.nextBlock = splt;
        return splt;
    }

    private static final class BlockListIterator
    implements Iterator<Block> {
        private Block curr;

        public BlockListIterator(Block start) {
            this.curr = start;
        }

        @Override
        public boolean hasNext() {
            return this.curr != null;
        }

        @Override
        public Block next() {
            Block result = this.curr;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.curr = result.nextBlock;
            return result;
        }
    }
}

