/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.partitionrefinement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.simple.SimpleDeterministicAutomaton;
import net.automatalib.util.partitionrefinement.Block;
import net.automatalib.util.partitionrefinement.PaigeTarjan;
import net.automatalib.words.Alphabet;

public class PaigeTarjanInitializers {
    public static void initCompleteDeterministic(PaigeTarjan pt, UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> absAutomaton, AutomatonInitialPartitioning ip, boolean pruneUnreachable) {
        PaigeTarjanInitializers.initCompleteDeterministic(pt, absAutomaton, ip.initialClassifier(absAutomaton), pruneUnreachable);
    }

    public static void initCompleteDeterministic(PaigeTarjan pt, SimpleDeterministicAutomaton.FullIntAbstraction absAutomaton, IntFunction<?> initialClassification, boolean pruneUnreachable) {
        if (pruneUnreachable) {
            PaigeTarjanInitializers.initCompleteDeterministicPrune(pt, absAutomaton, initialClassification);
        } else {
            PaigeTarjanInitializers.initCompleteDeterministicNoPrune(pt, absAutomaton, initialClassification);
        }
    }

    private static void initCompleteDeterministicPrune(PaigeTarjan pt, SimpleDeterministicAutomaton.FullIntAbstraction absAutomaton, IntFunction<?> initialClassification) {
        int curr;
        int numStates = absAutomaton.size();
        int numInputs = absAutomaton.numInputs();
        int posDataLow = numStates;
        int predOfsDataLow = posDataLow + numStates;
        int numTransitions = numStates * numInputs;
        int predDataLow = predOfsDataLow + numTransitions + 1;
        int dataSize = predDataLow + numTransitions;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStates];
        HashMap blockMap = new HashMap();
        int init = absAutomaton.getIntInitialState();
        Object initClass = initialClassification.apply(init);
        Block initBlock = pt.createBlock();
        initBlock.high = 1;
        blockForState[init] = initBlock;
        blockMap.put(initClass, initBlock);
        int[] statesBuff = new int[numStates];
        statesBuff[0] = init;
        int statesPtr = 0;
        int reachableStates = 1;
        while (statesPtr < reachableStates) {
            curr = statesBuff[statesPtr++];
            int predCountBase = predOfsDataLow;
            for (int i = 0; i < numInputs; ++i) {
                int succ = absAutomaton.getSuccessor(curr, i);
                if (succ < 0) {
                    throw new IllegalArgumentException("Automaton must not be partial");
                }
                Block succBlock = blockForState[succ];
                if (succBlock == null) {
                    Object succClass = initialClassification.apply(succ);
                    succBlock = (Block)blockMap.get(succClass);
                    if (succBlock == null) {
                        succBlock = pt.createBlock();
                        succBlock.high = 0;
                        blockMap.put(succClass, succBlock);
                    }
                    ++succBlock.high;
                    blockForState[succ] = succBlock;
                    statesBuff[reachableStates++] = succ;
                }
                int n = predCountBase + succ;
                data[n] = data[n] + 1;
                predCountBase += numStates;
            }
        }
        curr = 0;
        for (Block b : pt.blockList()) {
            b.high = curr += b.high;
            b.low = curr;
        }
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        for (int i = 0; i < reachableStates; ++i) {
            int stateId = statesBuff[i];
            Block b = blockForState[stateId];
            int pos = --b.low;
            data[pos] = stateId;
            data[posDataLow + stateId] = pos;
            int predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succ = absAutomaton.getSuccessor(stateId, j);
                assert (succ >= 0);
                int n2 = predOfsBase + succ;
                int n3 = data[n2] - 1;
                data[n2] = n3;
                data[n3] = stateId;
                predOfsBase += numStates;
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setBlockForState(blockForState);
        pt.setSize(numStates, numInputs);
    }

    private static void initCompleteDeterministicNoPrune(PaigeTarjan pt, SimpleDeterministicAutomaton.FullIntAbstraction absAutomaton, IntFunction<?> initialClassification) {
        int numStates = absAutomaton.size();
        int numInputs = absAutomaton.numInputs();
        int posDataLow = numStates;
        int predOfsDataLow = posDataLow + numStates;
        int numTransitions = numStates * numInputs;
        int predDataLow = predOfsDataLow + numTransitions + 1;
        int dataSize = predDataLow + numTransitions;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStates];
        HashMap<Object, Block> blockMap = new HashMap<Object, Block>();
        for (int i = 0; i < numStates; ++i) {
            Object classification = initialClassification.apply(i);
            Block block = (Block)blockMap.get(classification);
            if (block == null) {
                block = pt.createBlock();
                block.high = 0;
                blockMap.put(classification, block);
            }
            ++block.high;
            blockForState[i] = block;
            int predCountBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succ = absAutomaton.getSuccessor(i, j);
                if (succ < 0) {
                    throw new IllegalArgumentException("Automaton must not be partial");
                }
                int n = predCountBase + succ;
                data[n] = data[n] + 1;
                predCountBase += numStates;
            }
        }
        int curr = 0;
        for (Block b : pt.blockList()) {
            b.high = curr += b.high;
            b.low = curr;
        }
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        for (int i = 0; i < numStates; ++i) {
            Block b;
            b = blockForState[i];
            int pos = --b.low;
            data[pos] = i;
            data[posDataLow + i] = pos;
            int predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succ = absAutomaton.getSuccessor(i, j);
                assert (succ >= 0);
                int n2 = predOfsBase + succ;
                int n3 = data[n2] - 1;
                data[n2] = n3;
                data[n3] = i;
                predOfsBase += numStates;
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setBlockForState(blockForState);
        pt.setSize(numStates, numInputs);
    }

    public static <S, I> StateIDs<S> initDeterministic(PaigeTarjan pt, SimpleDeterministicAutomaton<S, I> automaton, Alphabet<I> inputs, Function<? super S, ?> initialClassification, Object sinkClassification) {
        int numStatesWithSink;
        int numStates = automaton.size();
        int numInputs = inputs.size();
        int sinkId = numStates;
        int posDataLow = numStatesWithSink = numStates + 1;
        int predOfsDataLow = posDataLow + numStatesWithSink;
        int numTransitionsFull = numStatesWithSink * numInputs;
        int predDataLow = predOfsDataLow + numTransitionsFull + 1;
        int dataSize = predDataLow + numTransitionsFull;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStatesWithSink];
        StateIDs ids = automaton.stateIDs();
        HashMap<Object, Block> blockMap = new HashMap<Object, Block>();
        Object init = automaton.getInitialState();
        int initId = ids.getStateId(init);
        Object initClass = initialClassification.apply(init);
        Block initBlock = pt.createBlock();
        initBlock.high = 1;
        blockForState[initId] = initBlock;
        blockMap.put(initClass, initBlock);
        int[] statesBuff = new int[numStatesWithSink];
        statesBuff[0] = initId;
        int statesPtr = 0;
        int reachableStates = 1;
        boolean partial = false;
        while (statesPtr < reachableStates) {
            int currId;
            if ((currId = statesBuff[statesPtr++]) == sinkId) continue;
            Object curr = ids.getState(currId);
            int predCountBase = predOfsDataLow;
            for (int i = 0; i < numInputs; ++i) {
                int succId;
                I sym = inputs.getSymbol(i);
                Object succ = automaton.getSuccessor(curr, sym);
                if (succ != null) {
                    succId = ids.getStateId(succ);
                } else {
                    succId = sinkId;
                    partial = true;
                }
                Block succBlock = blockForState[succId];
                if (succBlock == null) {
                    Object succClass = succ != null ? initialClassification.apply(succ) : sinkClassification;
                    succBlock = (Block)blockMap.get(succClass);
                    if (succBlock == null) {
                        succBlock = pt.createBlock();
                        succBlock.high = 0;
                        blockMap.put(succClass, succBlock);
                    }
                    ++succBlock.high;
                    blockForState[succId] = succBlock;
                    statesBuff[reachableStates++] = succId;
                }
                int n = predCountBase + succId;
                data[n] = data[n] + 1;
                predCountBase += numStatesWithSink;
            }
        }
        if (partial) {
            int predCountIdx = predOfsDataLow + sinkId;
            for (int i = 0; i < numInputs; ++i) {
                int n = predCountIdx;
                data[n] = data[n] + 1;
                predCountIdx += numStatesWithSink;
            }
        }
        int curr = 0;
        for (Block b : pt.blockList()) {
            b.high = curr += b.high;
            b.low = curr;
        }
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        if (partial) {
            int predOfsIdx = predOfsDataLow + sinkId;
            for (int i = 0; i < numInputs; ++i) {
                int n2 = predOfsIdx;
                int n3 = data[n2] - 1;
                data[n2] = n3;
                data[n3] = sinkId;
                predOfsIdx += numStatesWithSink;
            }
        }
        for (int i = 0; i < reachableStates; ++i) {
            int stateId = statesBuff[i];
            Block b = blockForState[stateId];
            int pos = --b.low;
            data[pos] = stateId;
            data[posDataLow + stateId] = pos;
            Object state = ids.getState(stateId);
            int predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                I sym = inputs.getSymbol(j);
                Object succ = automaton.getSuccessor(state, sym);
                int succId = succ == null ? sinkId : ids.getStateId(succ);
                int n4 = predOfsBase + succId;
                int n5 = data[n4] - 1;
                data[n4] = n5;
                data[n5] = stateId;
                predOfsBase += numStatesWithSink;
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setSize(numStatesWithSink, numInputs);
        pt.setBlockForState(blockForState);
        return ids;
    }

    public static <S, I, T> StateIDs<S> initDeterministic(PaigeTarjan pt, DeterministicAutomaton<S, I, T> automaton, Alphabet<I> inputs, Predicate<? super S> initialClassification, boolean sinkClassification) {
        I sym;
        int predOfsBase;
        int i;
        int initPos;
        int numStatesWithSink;
        int numStates = automaton.size();
        int numInputs = inputs.size();
        int sinkId = numStates;
        int posDataLow = numStatesWithSink = numStates + 1;
        int predOfsDataLow = posDataLow + numStatesWithSink;
        int numTransitionsFull = numStatesWithSink * numInputs;
        int predDataLow = predOfsDataLow + numTransitionsFull + 1;
        int dataSize = predDataLow + numTransitionsFull;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStatesWithSink];
        StateIDs ids = automaton.stateIDs();
        Object init = automaton.getInitialState();
        int initId = ids.getStateId(init);
        int falsePtr = 0;
        int truePtr = numStatesWithSink;
        Block falseBlock = pt.createBlock();
        Block trueBlock = pt.createBlock();
        boolean initClass = initialClassification.test(init);
        if (initClass) {
            blockForState[initId] = trueBlock;
            initPos = --truePtr;
        } else {
            blockForState[initId] = falseBlock;
            initPos = falsePtr++;
        }
        data[initPos] = initId;
        data[posDataLow + initId] = initPos;
        int currFalse = 0;
        int currTrue = numStatesWithSink;
        int pending = 1;
        boolean partial = false;
        while (pending-- > 0) {
            int stateId = -1;
            if (currFalse < falsePtr) {
                stateId = data[currFalse++];
            } else if (currTrue > truePtr) {
                stateId = data[--currTrue];
            } else {
                throw new AssertionError();
            }
            Object state = ids.getState(stateId);
            int predCountBase = predOfsDataLow;
            for (int i2 = 0; i2 < numInputs; ++i2) {
                int succId;
                I sym2 = inputs.getSymbol(i2);
                Object trans = automaton.getTransition(state, sym2);
                if (trans == null) {
                    partial = true;
                    succId = sinkId;
                } else {
                    Object succ = automaton.getSuccessor(trans);
                    succId = ids.getStateId(succ);
                    if (blockForState[succId] == null) {
                        int succPos;
                        boolean succClass = initialClassification.test(succ);
                        if (succClass) {
                            blockForState[succId] = trueBlock;
                            succPos = --truePtr;
                        } else {
                            blockForState[succId] = falseBlock;
                            succPos = falsePtr++;
                        }
                        data[succPos] = succId;
                        data[posDataLow + succId] = succPos;
                        ++pending;
                    }
                    int n = predCountBase + succId;
                    data[n] = data[n] + 1;
                }
                predCountBase += numStatesWithSink;
            }
        }
        if (partial) {
            int pos;
            if (sinkClassification) {
                blockForState[sinkId] = trueBlock;
                pos = --truePtr;
            } else {
                blockForState[sinkId] = falseBlock;
                pos = falsePtr++;
            }
            data[pos] = sinkId;
            data[posDataLow + sinkId] = pos;
            int predCountIdx = predOfsDataLow + sinkId;
            for (int i3 = 0; i3 < numInputs; ++i3) {
                int n = predCountIdx;
                data[n] = data[n] + 1;
                predCountIdx += numStatesWithSink;
            }
        }
        falseBlock.low = 0;
        falseBlock.high = falsePtr;
        trueBlock.low = truePtr;
        trueBlock.high = numStatesWithSink;
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        if (partial) {
            int predOfsIdx = predOfsDataLow + sinkId;
            for (int i4 = 0; i4 < numInputs; ++i4) {
                int n2 = predOfsIdx;
                int n3 = data[n2] - 1;
                data[n2] = n3;
                data[n3] = sinkId;
                predOfsIdx += numStatesWithSink;
            }
        }
        for (i = 0; i < falsePtr; ++i) {
            int stateId = data[i];
            Object state = ids.getState(stateId);
            predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succId;
                sym = inputs.getSymbol(j);
                Object trans = automaton.getTransition(state, sym);
                if (trans == null) {
                    succId = sinkId;
                } else {
                    Object succ = automaton.getSuccessor(trans);
                    succId = ids.getStateId(succ);
                }
                int n4 = predOfsBase + succId;
                int n5 = data[n4] - 1;
                data[n4] = n5;
                data[n5] = stateId;
                predOfsBase += numStatesWithSink;
            }
        }
        for (i = truePtr; i < numStatesWithSink; ++i) {
            int stateId = data[i];
            Object state = ids.getState(stateId);
            predOfsBase = predOfsDataLow;
            for (int j = 0; j < numInputs; ++j) {
                int succId;
                sym = inputs.getSymbol(j);
                Object trans = automaton.getTransition(state, sym);
                if (trans == null) {
                    succId = sinkId;
                } else {
                    Object succ = automaton.getSuccessor(trans);
                    succId = ids.getStateId(succ);
                }
                int n6 = predOfsBase + succId;
                int n7 = data[n6] - 1;
                data[n6] = n7;
                data[n7] = stateId;
                predOfsBase += numStatesWithSink;
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setBlockForState(blockForState);
        pt.setSize(numStatesWithSink, numInputs);
        pt.removeEmptyBlocks();
        return ids;
    }

    public static void prefixSum(int[] array, int startInclusive, int endExclusive) {
        int curr = array[startInclusive];
        for (int i = startInclusive + 1; i < endExclusive; ++i) {
            array[i] = curr += array[i];
        }
    }

    private static final class CompleteStateSignature {
        private final Object[] properties;

        public static CompleteStateSignature build(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton, int state) {
            int numInputs = automaton.numInputs();
            Object[] properties = new Object[numInputs + 1];
            CompleteStateSignature.fillTransitionProperties(automaton, state, properties);
            properties[numInputs] = automaton.getStateProperty(state);
            return new CompleteStateSignature(properties);
        }

        public static <S, I> CompleteStateSignature build(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet, S state) {
            int numInputs = alphabet.size();
            Object[] properties = new Object[numInputs + 1];
            CompleteStateSignature.fillTransitionProperties(automaton, alphabet, state, properties);
            properties[numInputs] = automaton.getStateProperty(state);
            return new CompleteStateSignature(properties);
        }

        public static CompleteStateSignature buildFromTransitions(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton, int state) {
            int numInputs = automaton.numInputs();
            Object[] properties = new Object[numInputs];
            CompleteStateSignature.fillTransitionProperties(automaton, state, properties);
            return new CompleteStateSignature(properties);
        }

        public static <S, I> CompleteStateSignature buildFromTransitions(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet, S state) {
            int numInputs = alphabet.size();
            Object[] properties = new Object[numInputs];
            for (int i = 0; i < numInputs; ++i) {
                I sym = alphabet.getSymbol(i);
                properties[i] = automaton.getTransitionProperty(state, sym);
            }
            return new CompleteStateSignature(properties);
        }

        private static void fillTransitionProperties(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton, int state, Object[] properties) {
            int numInputs = automaton.numInputs();
            for (int i = 0; i < numInputs; ++i) {
                properties[i] = automaton.getTransitionProperty(state, i);
            }
        }

        private static <S, I> void fillTransitionProperties(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet, S state, Object[] properties) {
            int numInputs = alphabet.size();
            for (int i = 0; i < numInputs; ++i) {
                I sym = alphabet.getSymbol(i);
                properties[i] = automaton.getTransitionProperty(state, sym);
            }
        }

        public CompleteStateSignature(Object[] properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != CompleteStateSignature.class) {
                return false;
            }
            CompleteStateSignature other = (CompleteStateSignature)o;
            return Arrays.equals(this.properties, other.properties);
        }

        public int hashCode() {
            return Arrays.hashCode(this.properties);
        }
    }

    public static enum AutomatonInitialPartitioning {
        BY_STATE_PROPERTY{

            @Override
            public IntFunction<Object> initialClassifier(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton) {
                return s -> automaton.getStateProperty(s);
            }

            @Override
            public <S, I> Function<S, Object> initialClassifier(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet) {
                return s -> automaton.getStateProperty(s);
            }
        }
        ,
        BY_TRANSITION_PROPERTIES{

            @Override
            public IntFunction<Object> initialClassifier(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton) {
                return s -> CompleteStateSignature.buildFromTransitions(automaton, s);
            }

            @Override
            public <S, I> Function<S, Object> initialClassifier(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet) {
                return s -> CompleteStateSignature.buildFromTransitions(automaton, alphabet, s);
            }
        }
        ,
        BY_FULL_SIGNATURE{

            @Override
            public IntFunction<Object> initialClassifier(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> automaton) {
                return s -> CompleteStateSignature.build(automaton, s);
            }

            @Override
            public <S, I> Function<S, Object> initialClassifier(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Alphabet<I> alphabet) {
                return s -> CompleteStateSignature.build(automaton, alphabet, s);
            }
        };


        public abstract IntFunction<Object> initialClassifier(UniversalDeterministicAutomaton.FullIntAbstraction<?, ?, ?> var1);

        public abstract <S, I> Function<S, Object> initialClassifier(UniversalDeterministicAutomaton<S, I, ?, ?, ?> var1, Alphabet<I> var2);
    }
}

