/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.UniversalTransitionSystem;
import net.automatalib.util.ts.TSIterators;
import net.automatalib.util.ts.traversal.BFSOrderIterator;

public abstract class TS {
    public static <S, I> Iterable<S> bfsOrder(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return () -> TS.bfsOrderIterator(ts, inputs);
    }

    public static <S, I> Iterator<S> bfsOrderIterator(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return new BFSOrderIterator(ts, inputs);
    }

    public static <S, SP> Function<S, SP> stateProperties(UniversalTransitionSystem<S, ?, ?, SP, ?> uts) {
        return s -> uts.getStateProperty(s);
    }

    public static <T, TP> Function<T, TP> transitionProperties(UniversalTransitionSystem<?, ?, T, ?, TP> uts) {
        return t -> uts.getTransitionProperty(t);
    }

    public static <S, I> Iterator<I> definedInputsIterator(TransitionSystem<S, I, ?> ts, S state, Iterator<? extends I> inputsIt) {
        return new TSIterators.DefinedInputsIterator<S, I>(ts, state, inputsIt);
    }

    public static <S, I> Iterable<I> definedInputs(final DeterministicTransitionSystem<S, I, ?> dts, final S state, final Iterable<? extends I> inputs) {
        return new Iterable<I>(){

            @Override
            public Iterator<I> iterator() {
                return TS.definedInputsIterator(dts, state, inputs.iterator());
            }
        };
    }

    public static <S, I> Iterator<TransRef<S, I, ?>> allDefinedInputsIterator(TransitionSystem<S, I, ?> ts, Iterator<? extends S> stateIt, Iterable<? extends I> inputs) {
        return new TSIterators.AllDefinedInputsIterator<S, I>(stateIt, ts, inputs);
    }

    public static <S, I> Iterable<TransRef<S, I, ?>> allDefinedInputs(final TransitionSystem<S, I, ?> ts, final Iterable<? extends S> states, final Iterable<? extends I> inputs) {
        return new Iterable<TransRef<S, I, ?>>(){

            @Override
            public Iterator<TransRef<S, I, ?>> iterator() {
                return TS.allDefinedInputsIterator(ts, states.iterator(), inputs);
            }
        };
    }

    public static <S, I> Iterator<I> undefinedInputsIterator(TransitionSystem<S, I, ?> ts, S state, Iterator<? extends I> inputsIt) {
        return new TSIterators.UndefinedInputsIterator<S, I>(ts, state, inputsIt);
    }

    public static <S, I> Iterable<I> undefinedInputs(final TransitionSystem<S, I, ?> ts, final S state, final Iterable<? extends I> inputs) {
        return new Iterable<I>(){

            @Override
            public Iterator<I> iterator() {
                return TS.undefinedInputsIterator(ts, state, inputs.iterator());
            }
        };
    }

    public static <S, I> Iterator<TransRef<S, I, ?>> allUndefinedTransitionsIterator(TransitionSystem<S, I, ?> ts, Iterator<? extends S> stateIt, Iterable<? extends I> inputs) {
        return new TSIterators.AllUndefinedInputsIterator<S, I>(stateIt, ts, inputs);
    }

    public static <S, I> Iterable<TransRef<S, I, ?>> allUndefinedTransitions(final TransitionSystem<S, I, ?> ts, final Iterable<? extends S> states, final Iterable<? extends I> inputs) {
        return new Iterable<TransRef<S, I, ?>>(){

            @Override
            public Iterator<TransRef<S, I, ?>> iterator() {
                return TS.allUndefinedTransitionsIterator(ts, states.iterator(), inputs);
            }
        };
    }

    public static final class TransRef<S, I, T> {
        public final S state;
        public final I input;
        public final T transition;

        public TransRef(S state, I input, T transition) {
            this.state = state;
            this.input = input;
            this.transition = transition;
        }

        public TransRef(S state, I input) {
            this(state, input, null);
        }
    }
}

