/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.copy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.commons.util.Holder;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.ts.traversal.TSTraversalAction;
import net.automatalib.util.ts.traversal.TSTraversalVisitor;

public class TSCopyVisitor<S1, I1, T1, S2, I2, T2, SP2, TP2>
implements TSTraversalVisitor<S1, I1, T1, S2> {
    private final MutableMapping<S1, S2> stateMapping;
    private final MutableAutomaton<S2, I2, T2, ? super SP2, ? super TP2> out;
    private final Function<? super I1, ? extends I2> inputMapping;
    private final Function<? super S1, ? extends SP2> spMapping;
    private final Function<? super T1, ? extends TP2> tpMapping;
    private final Predicate<? super S1> stateFilter;
    private final TransitionPredicate<? super S1, ? super I1, ? super T1> transFilter;

    public TSCopyVisitor(TransitionSystem<S1, ? super I1, T1> in, MutableAutomaton<S2, I2, T2, ? super SP2, ? super TP2> out, Function<? super I1, ? extends I2> inputMapping, Function<? super S1, ? extends SP2> spMapping, Function<? super T1, ? extends TP2> tpMapping, Predicate<? super S1> stateFilter, TransitionPredicate<? super S1, ? super I1, ? super T1> transFilter) {
        this.stateMapping = in.createStaticStateMapping();
        this.out = out;
        this.inputMapping = inputMapping;
        this.spMapping = spMapping;
        this.tpMapping = tpMapping;
        this.stateFilter = stateFilter;
        this.transFilter = transFilter;
    }

    @Override
    public TSTraversalAction processInitial(S1 state, Holder<S2> outData) {
        Object s2 = this.stateMapping.get(state);
        if (s2 != null) {
            this.out.setInitial(s2, true);
            return TSTraversalAction.IGNORE;
        }
        if (!this.stateFilter.apply(state)) {
            return TSTraversalAction.IGNORE;
        }
        Object sp = this.spMapping.apply(state);
        s2 = this.out.addInitialState(sp);
        this.stateMapping.put(state, s2);
        outData.value = s2;
        return TSTraversalAction.EXPLORE;
    }

    @Override
    public boolean startExploration(S1 state, S2 data) {
        return true;
    }

    @Override
    public TSTraversalAction processTransition(S1 source, S2 source2, I1 input, T1 transition, S1 succ, Holder<S2> outData) {
        if (!this.transFilter.apply(source, input, transition)) {
            return TSTraversalAction.IGNORE;
        }
        boolean ignore = false;
        Object succ2 = this.stateMapping.get(succ);
        if (succ2 == null) {
            if (!this.stateFilter.apply(succ)) {
                return TSTraversalAction.IGNORE;
            }
            Object sp = this.spMapping.apply(succ);
            succ2 = this.out.addState(sp);
            this.stateMapping.put(succ, succ2);
        } else {
            ignore = true;
        }
        Object input2 = this.inputMapping.apply(input);
        Object tp = this.tpMapping.apply(transition);
        this.out.addTransition(source2, input2, succ2, tp);
        outData.value = succ2;
        return ignore ? TSTraversalAction.IGNORE : TSTraversalAction.EXPLORE;
    }

    public Mapping<S1, S2> getStateMapping() {
        return this.stateMapping;
    }
}

