/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.AutomataLibSettings;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.GraphViewable;
import net.automatalib.graphs.dot.AggregateDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.visualization.VPManager;
import net.automatalib.visualization.VisualizationProvider;

public class Visualization {
    private static final Visualization INSTANCE = new Visualization();
    private final VPManager manager = new VPManager();
    private final VisualizationProvider provider;

    public static void visualize(GraphViewable gv, boolean modal) {
        Visualization.visualizeGraph(gv.graphView(), modal, new GraphDOTHelper[0]);
    }

    @SafeVarargs
    public static <N, E> void visualizeGraph(Graph<N, E> graph, boolean modal, GraphDOTHelper<N, ? super E> ... addlHelpers) {
        INSTANCE.visualize(graph, modal, addlHelpers);
    }

    @SafeVarargs
    public static <S, I, T> void visualizeAutomaton(Automaton<S, I, T> automaton, Collection<? extends I> inputs, boolean modal, GraphDOTHelper<S, TransitionEdge<I, T>> ... addlHelpers) {
        Visualization.visualizeGraph(automaton.transitionGraphView(inputs), modal, addlHelpers);
    }

    private Visualization() {
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String providerId = settings.getProperty("visualization.provider");
        VisualizationProvider vp = null;
        this.manager.load();
        if (providerId != null) {
            vp = this.manager.getProviderByName(providerId);
        }
        if (vp == null) {
            vp = this.manager.getBestProvider();
        }
        if (vp == null) {
            System.err.println("Error setting visualization provider, defaulting to dummy provider...");
        }
        this.provider = vp;
    }

    @SafeVarargs
    public final <N, E> void visualize(Graph<N, E> graph, boolean modal, GraphDOTHelper<N, ? super E> ... addlHelpers) {
        ArrayList<GraphDOTHelper<N, E>> helpers = new ArrayList<GraphDOTHelper<N, E>>(addlHelpers.length + 1);
        helpers.add(graph.getGraphDOTHelper());
        for (GraphDOTHelper<N, ? super E> h : addlHelpers) {
            helpers.add(h);
        }
        AggregateDOTHelper aggHelper = new AggregateDOTHelper(helpers);
        this.visualize(graph, aggHelper, modal, Collections.emptyMap());
    }

    public <N, E> void visualize(Graph<N, E> graph, GraphDOTHelper<N, ? super E> helper, boolean modal, Map<String, String> options) {
        this.provider.visualize(graph, helper, modal, options);
    }
}

