/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.jung;

import com.github.misberner.graphvizawtshapes.ShapeLibrary;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.visualization.VisualizationProvider;
import org.apache.commons.collections15.Transformer;

public class JungGraphVisualizationProvider
implements VisualizationProvider {
    private final PluggableGraphMouse mouse = new PluggableGraphMouse();

    protected static NodeVisualization createNodeVisualization(Map<String, String> props, int id) {
        BasicStroke stroke;
        ShapeLibrary shapeLib;
        Shape shape;
        String label = props.get("label");
        if (label == null) {
            label = "v" + id;
        }
        Color drawColor = JungGraphVisualizationProvider.getColor(props, "color", Color.BLACK);
        Color fillColor = JungGraphVisualizationProvider.getColor(props, "fillcolor", Color.WHITE);
        String shapeName = props.get("shape");
        if (shapeName == null) {
            shapeName = "circle";
        }
        if ((shape = (shapeLib = ShapeLibrary.getInstance()).createShape(shapeName)) == null) {
            System.err.println("Could not create shape " + shapeName);
            shape = shapeLib.createShape("circle");
        }
        String[] styles = new String[]{};
        String styleAttr = props.get("style");
        if (styleAttr != null) {
            styles = styleAttr.toLowerCase().split(",");
        }
        List<String> styleList = Arrays.asList(styles);
        float penWidth = 1.0f;
        if (styleList.contains("bold")) {
            penWidth = 3.0f;
        }
        if (styleList.contains("dashed")) {
            float[] dash = new float[]{10.0f};
            stroke = new BasicStroke(penWidth, 0, 0, 10.0f, dash, 0.0f);
        } else if (styleList.contains("dotted")) {
            float[] dash = new float[]{penWidth, penWidth + 7.0f};
            stroke = new BasicStroke(penWidth, 0, 0, 10.0f, dash, 0.0f);
        } else {
            stroke = new BasicStroke(penWidth);
        }
        return new NodeVisualization(label, drawColor, fillColor, shape, stroke);
    }

    protected static EdgeVisualization createEdgeVisualization(Map<String, String> props) {
        String label = props.get("label");
        if (label == null) {
            label = "";
        }
        Color drawColor = JungGraphVisualizationProvider.getColor(props, "color", Color.BLACK);
        return new EdgeVisualization(label, drawColor);
    }

    protected static Color getColor(Map<String, String> props, String propName, Color defColor) {
        String colName = props.get(propName);
        if (colName == null) {
            return defColor;
        }
        Color col = Color.getColor(colName);
        if (col == null) {
            return defColor;
        }
        return col;
    }

    public static <N, E> DirectedGraph<NodeVisualization, EdgeVisualization> createVisualizationGraph(Graph<N, E> graph, GraphDOTHelper<N, ? super E> helper) {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        helper.getGlobalNodeProperties(defaultProps);
        DirectedSparseMultigraph jungGraph = new DirectedSparseMultigraph();
        MutableMapping mapping = graph.createStaticNodeMapping();
        NodeIDs nodeIds = graph.nodeIDs();
        for (Object node : graph) {
            int id = nodeIds.getNodeId(node);
            HashMap<String, String> props = new HashMap<String, String>(defaultProps);
            helper.getNodeProperties(node, props);
            NodeVisualization vis = JungGraphVisualizationProvider.createNodeVisualization(props, id);
            mapping.put(node, vis);
        }
        defaultProps = new HashMap();
        helper.getGlobalEdgeProperties(defaultProps);
        for (Object node : graph) {
            NodeVisualization srcVis = (NodeVisualization)mapping.get(node);
            for (Object edge : graph.getOutgoingEdges(node)) {
                Object target = graph.getTarget(edge);
                NodeVisualization tgtVis = (NodeVisualization)mapping.get(target);
                HashMap<String, String> props = new HashMap<String, String>(defaultProps);
                helper.getEdgeProperties(node, edge, target, props);
                EdgeVisualization edgeVis = JungGraphVisualizationProvider.createEdgeVisualization(props);
                jungGraph.addEdge((Object)edgeVis, (Object)srcVis, (Object)tgtVis);
            }
        }
        return jungGraph;
    }

    public JungGraphVisualizationProvider() {
        this.mouse.add((GraphMousePlugin)new PickingGraphMousePlugin());
        this.mouse.add((GraphMousePlugin)new TranslatingGraphMousePlugin(4));
        this.mouse.add((GraphMousePlugin)new ScalingGraphMousePlugin((ScalingControl)new CrossoverScalingControl(), 0, 0.9090909f, 1.1f));
    }

    public static void setupRenderContext(RenderContext<NodeVisualization, EdgeVisualization> ctx) {
        ctx.setVertexLabelTransformer(NodeVisualization.LABEL);
        ctx.setVertexDrawPaintTransformer(NodeVisualization.DRAW_COLOR);
        ctx.setVertexFillPaintTransformer(NodeVisualization.FILL_COLOR);
        ctx.setVertexShapeTransformer(NodeVisualization.SHAPE);
        ctx.setVertexStrokeTransformer(NodeVisualization.STROKE);
        ctx.setEdgeLabelTransformer(EdgeVisualization.LABEL);
        ctx.setEdgeDrawPaintTransformer(EdgeVisualization.DRAW_COLOR);
    }

    @Override
    public <N, E> void visualize(Graph<N, E> graph, GraphDOTHelper<N, ? super E> helper, boolean modal, Map<String, String> options) {
        DirectedGraph<NodeVisualization, EdgeVisualization> visGraph = JungGraphVisualizationProvider.createVisualizationGraph(graph, helper);
        KKLayout layout = new KKLayout(visGraph);
        VisualizationViewer vv = new VisualizationViewer((Layout)layout);
        JungGraphVisualizationProvider.setupRenderContext((RenderContext<NodeVisualization, EdgeVisualization>)vv.getRenderContext());
        vv.setGraphMouse((VisualizationViewer.GraphMouse)this.mouse);
        JDialog frame = new JDialog((Dialog)null, "Visualization", modal);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)vv);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public String getId() {
        return "jung";
    }

    @Override
    public boolean checkUsable() {
        return true;
    }

    public static final class EdgeVisualization {
        public static final Transformer<EdgeVisualization, String> LABEL = new Transformer<EdgeVisualization, String>(){

            public String transform(EdgeVisualization input) {
                return input.label;
            }
        };
        public static final Transformer<EdgeVisualization, Paint> DRAW_COLOR = new Transformer<EdgeVisualization, Paint>(){

            public Paint transform(EdgeVisualization input) {
                return input.drawColor;
            }
        };
        public final String label;
        public final Color drawColor;

        public EdgeVisualization(String label, Color drawColor) {
            this.label = label;
            this.drawColor = drawColor;
        }
    }

    public static final class NodeVisualization {
        public static final Transformer<NodeVisualization, String> LABEL = new Transformer<NodeVisualization, String>(){

            public String transform(NodeVisualization input) {
                return input.label;
            }
        };
        public static final Transformer<NodeVisualization, Paint> DRAW_COLOR = new Transformer<NodeVisualization, Paint>(){

            public Paint transform(NodeVisualization input) {
                return input.color;
            }
        };
        public static final Transformer<NodeVisualization, Paint> FILL_COLOR = new Transformer<NodeVisualization, Paint>(){

            public Paint transform(NodeVisualization input) {
                return input.fillColor;
            }
        };
        public static final Transformer<NodeVisualization, Shape> SHAPE = new Transformer<NodeVisualization, Shape>(){

            public Shape transform(NodeVisualization input) {
                return input.shape;
            }
        };
        public static final Transformer<NodeVisualization, Stroke> STROKE = new Transformer<NodeVisualization, Stroke>(){

            public Stroke transform(NodeVisualization input) {
                return input.stroke;
            }
        };
        public final String label;
        public final Color color;
        public final Color fillColor;
        public final Shape shape;
        public final Stroke stroke;

        public NodeVisualization(String label, Color drawColor, Color fillColor, Shape shape, Stroke stroke) {
            this.label = label;
            this.color = drawColor;
            this.fillColor = fillColor;
            this.shape = shape;
            this.stroke = stroke;
        }
    }
}

