/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.automatalib.commons.util.array.ArrayWritable;
import net.automatalib.commons.util.mappings.Mapping;

public interface Alphabet<I>
extends ArrayWritable<I>,
Collection<I>,
Comparator<I>,
IntFunction<I>,
ToIntFunction<I> {
    @Nullable
    public I getSymbol(int var1) throws IllegalArgumentException;

    public int getSymbolIndex(@Nullable I var1) throws IllegalArgumentException;

    @Override
    default public I apply(int index) {
        return this.getSymbol(index);
    }

    @Override
    default public int applyAsInt(I symbol) {
        return this.getSymbolIndex(symbol);
    }

    @Override
    default public int compare(I o1, I o2) {
        return this.getSymbolIndex(o1) - this.getSymbolIndex(o2);
    }

    @Override
    default public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        int i = offset;
        int j = tgtOfs;
        for (int k = 0; k < num; ++k) {
            array[j] = this.getSymbol(i);
            ++i;
            ++j;
        }
    }

    default public <I2> Mapping<I2, I> translateFrom(Alphabet<I2> other) {
        if (other.size() > this.size()) {
            throw new IllegalArgumentException("Cannot translate from an alphabet with " + other.size() + " elements into an alphabet with only " + this.size() + " elements");
        }
        return i -> this.getSymbol(other.getSymbolIndex(i));
    }

    default public boolean containsSymbol(I symbol) {
        try {
            int index = this.getSymbolIndex(symbol);
            if (index < 0 || index >= this.size()) {
                return false;
            }
            return Objects.equals(symbol, this.getSymbol(index));
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }
}

