/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words;

import java.util.AbstractList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
class SubwordList<I>
extends AbstractList<Word<I>> {
    private final Word<I> word;
    private final boolean reverse;
    private final boolean prefix;

    public SubwordList(Word<I> word, boolean prefix, boolean reverse) {
        this.word = word;
        this.prefix = prefix;
        this.reverse = reverse;
    }

    @Override
    @Nonnull
    public Word<I> get(int index) {
        if (index < 0 || index > this.word.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.reverse) {
            index = this.word.length() - index;
        }
        if (this.prefix) {
            return this.word.prefix(index);
        }
        return this.word.suffix(index);
    }

    @Override
    public int size() {
        return this.word.length() + 1;
    }
}

