/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.AutomataLibSettings;
import net.automatalib.commons.util.array.AWUtil;
import net.automatalib.commons.util.array.ArrayWritable;
import net.automatalib.commons.util.strings.AbstractPrintable;
import net.automatalib.words.Alphabet;
import net.automatalib.words.CanonicalWordComparator;
import net.automatalib.words.EmptyWord;
import net.automatalib.words.LetterWord;
import net.automatalib.words.SharedWord;
import net.automatalib.words.SubwordList;

@ParametersAreNonnullByDefault
public abstract class Word<I>
extends AbstractPrintable
implements ArrayWritable<I>,
Iterable<I> {
    private static String emptyWordRep = "\u03b5";
    private static String wordDelimLeft = "";
    private static String wordDelimRight = "";
    private static String wordSymbolSeparator = " ";
    private static String wordSymbolDelimLeft = "";
    private static String wordSymbolDelimRight = "";

    public static <I> Comparator<Word<? extends I>> canonicalComparator(Comparator<? super I> symComparator) {
        return new CanonicalWordComparator<I>(symComparator);
    }

    @Nonnull
    public static <I> Word<I> epsilon() {
        return EmptyWord.INSTANCE;
    }

    @Nonnull
    public static <I> Word<I> fromLetter(@Nullable I letter) {
        return new LetterWord<I>(letter);
    }

    @SafeVarargs
    @Nonnull
    public static <I> Word<I> fromSymbols(I ... symbols) {
        if (symbols.length == 0) {
            return Word.epsilon();
        }
        if (symbols.length == 1) {
            return Word.fromLetter(symbols[0]);
        }
        Object[] array = new Object[symbols.length];
        System.arraycopy(symbols, 0, array, 0, symbols.length);
        return new SharedWord(symbols);
    }

    @Nonnull
    public static <I> Word<I> fromArray(I[] symbols, int offset, int length) {
        if (length == 0) {
            return Word.epsilon();
        }
        if (length == 1) {
            return Word.fromLetter(symbols[offset]);
        }
        Object[] array = new Object[length];
        System.arraycopy(symbols, offset, array, 0, length);
        return new SharedWord(symbols);
    }

    @Nonnull
    public static <I> Word<I> fromList(List<? extends I> symbolList) {
        int siz = symbolList.size();
        if (siz == 0) {
            return Word.epsilon();
        }
        if (siz == 1) {
            return Word.fromLetter(symbolList.get(0));
        }
        return new SharedWord<I>(symbolList);
    }

    @Nonnull
    public static Word<Character> fromCharSequence(CharSequence cs) {
        int len = cs.length();
        Object[] chars = new Character[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = Character.valueOf(cs.charAt(i));
        }
        return new SharedWord<Character>(chars);
    }

    @Nonnull
    public static Word<Character> fromString(String str) {
        return Word.fromCharSequence(str);
    }

    @SafeVarargs
    public static <I> Word<I> fromWords(Word<? extends I> ... words) {
        int totalLength = 0;
        for (Word<I> word : words) {
            totalLength += word.length();
        }
        if (totalLength == 0) {
            return Word.epsilon();
        }
        Object[] array = new Object[totalLength];
        int currOfs = 0;
        for (Word<I> word : words) {
            AWUtil.safeWrite(word, array, currOfs);
            currOfs += word.length();
        }
        return new SharedWord(array);
    }

    @Nullable
    public abstract I getSymbol(int var1);

    public abstract int length();

    public int hashCode() {
        int hash = 5;
        for (I sym : this) {
            hash *= 89;
            hash += sym != null ? sym.hashCode() : 0;
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Word)) {
            return false;
        }
        Word otherWord = (Word)other;
        int len = otherWord.length();
        if (len != this.length()) {
            return false;
        }
        java.util.Iterator<I> thisIt = this.iterator();
        java.util.Iterator<I> otherIt = otherWord.iterator();
        while (thisIt.hasNext()) {
            I otherSym;
            I thisSym = thisIt.next();
            if (Objects.equals(thisSym, otherSym = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void print(Appendable a) throws IOException {
        if (this.isEmpty()) {
            a.append(emptyWordRep);
        } else {
            a.append(wordDelimLeft);
            java.util.Iterator<I> symIt = this.iterator();
            assert (symIt.hasNext());
            Word.appendSymbol(a, symIt.next());
            while (symIt.hasNext()) {
                a.append(wordSymbolSeparator);
                Word.appendSymbol(a, symIt.next());
            }
            a.append(wordDelimRight);
        }
    }

    private static void appendSymbol(Appendable a, Object symbol) throws IOException {
        a.append(wordSymbolDelimLeft);
        a.append(String.valueOf(symbol));
        a.append(wordSymbolDelimRight);
    }

    @Override
    public final int size() {
        return this.length();
    }

    @Override
    public Spliterator<I> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 17424);
    }

    public Stream<I> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<I> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Nonnull
    public final Word<I> subWord(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < fromIndex || toIndex > this.length()) {
            throw new IndexOutOfBoundsException("Invalid subword range [" + fromIndex + ", " + toIndex + ")");
        }
        return this._subWord(fromIndex, toIndex);
    }

    @Nonnull
    public final Word<I> subWord(int fromIndex) {
        if (fromIndex <= 0) {
            if (fromIndex == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException("Invalid subword range [" + fromIndex + ",)");
        }
        return this._subWord(fromIndex, this.length());
    }

    @Nonnull
    protected Word<I> _subWord(int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        Object[] array = new Object[len];
        this.writeToArray(fromIndex, array, 0, len);
        return new SharedWord(array);
    }

    @Override
    @Nonnull
    public java.util.Iterator<I> iterator() {
        return new Iterator();
    }

    @Override
    public void writeToArray(int offset, Object[] array, int tgtOffset, int length) {
        int idx = offset;
        int arrayIdx = tgtOffset;
        while (length-- > 0) {
            array[arrayIdx++] = this.getSymbol(idx++);
        }
    }

    @Nonnull
    public List<I> asList() {
        return new AsList();
    }

    @Nonnull
    public final Word<I> prefix(int prefixLen) {
        if (prefixLen < 0) {
            prefixLen = this.length() + prefixLen;
        }
        return this.subWord(0, prefixLen);
    }

    @Nonnull
    public final Word<I> suffix(int suffixLen) {
        int wordLen = this.length();
        int startIdx = suffixLen < 0 ? -suffixLen : wordLen - suffixLen;
        return this.subWord(startIdx, wordLen);
    }

    @Nonnull
    public List<? extends Word<I>> prefixes(boolean longestFirst) {
        return new SubwordList(this, true, longestFirst);
    }

    @Nonnull
    public List<? extends Word<I>> suffixes(boolean longestFirst) {
        return new SubwordList(this, false, longestFirst);
    }

    @Nonnull
    public Word<I> canonicalNext(Alphabet<I> sigma) {
        int len = this.length();
        Object[] symbols = new Object[len];
        this.writeToArray(0, symbols, 0, len);
        int alphabetSize = sigma.size();
        int i = 0;
        boolean overflow = true;
        for (I sym : this) {
            int nextIdx = (sigma.getSymbolIndex(sym) + 1) % alphabetSize;
            symbols[i++] = sigma.getSymbol(nextIdx);
            if (nextIdx == 0) continue;
            overflow = false;
            break;
        }
        while (i < len) {
            symbols[i] = this.getSymbol(i);
            ++i;
        }
        if (overflow) {
            Object[] newSymbols = new Object[len + 1];
            newSymbols[0] = sigma.getSymbol(0);
            System.arraycopy(symbols, 0, newSymbols, 1, len);
            symbols = newSymbols;
        }
        return new SharedWord(symbols);
    }

    @Nullable
    public I lastSymbol() {
        return this.getSymbol(this.length() - 1);
    }

    @Nullable
    public I firstSymbol() {
        return this.getSymbol(0);
    }

    @Nonnull
    public Word<I> append(@Nullable I symbol) {
        int len = this.length();
        Object[] array = new Object[len + 1];
        this.writeToArray(0, array, 0, len);
        array[len] = symbol;
        return new SharedWord(array);
    }

    @Nonnull
    public Word<I> prepend(@Nullable I symbol) {
        int len = this.length();
        Object[] array = new Object[len + 1];
        array[0] = symbol;
        this.writeToArray(0, array, 1, len);
        return new SharedWord(array);
    }

    @SafeVarargs
    @Nonnull
    public final Word<I> concat(Word<? extends I> ... words) {
        return this._concat(words);
    }

    @Nonnull
    protected Word<I> _concat(Word<? extends I> ... words) {
        int len;
        if (words.length == 0) {
            return this;
        }
        int totalSize = len = this.length();
        for (int i = 0; i < words.length; ++i) {
            totalSize += words[i].length();
        }
        Object[] array = new Object[totalSize];
        this.writeToArray(0, array, 0, len);
        int currOfs = len;
        for (int i = 0; i < words.length; ++i) {
            Word<I> w = words[i];
            int wLen = w.length();
            w.writeToArray(0, array, currOfs, wLen);
            currOfs += wLen;
        }
        return new SharedWord(array);
    }

    public boolean isPrefixOf(Word<?> other) {
        int len = this.length();
        int otherLen = other.length();
        if (otherLen < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            Object sym2;
            I sym1 = this.getSymbol(i);
            if (Objects.equals(sym1, sym2 = other.getSymbol(i))) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Word<I> longestCommonPrefix(Word<?> other) {
        Object sym2;
        I sym1;
        int i;
        int otherLen;
        int len = this.length();
        int maxIdx = len < (otherLen = other.length()) ? len : otherLen;
        for (i = 0; i < maxIdx && Objects.equals(sym1 = this.getSymbol(i), sym2 = other.getSymbol(i)); ++i) {
        }
        return this.prefix(i);
    }

    public boolean isSuffixOf(Word<?> other) {
        int len = this.length();
        int otherLen = other.length();
        if (otherLen < len) {
            return false;
        }
        int ofs = otherLen - len;
        for (int i = 0; i < len; ++i) {
            Object sym2;
            I sym1 = this.getSymbol(i);
            if (Objects.equals(sym1, sym2 = other.getSymbol(ofs + i))) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Word<I> longestCommonSuffix(Word<?> other) {
        Object sym2;
        I sym1;
        int i;
        int otherLen;
        int len = this.length();
        int minLen = len < (otherLen = other.length()) ? len : otherLen;
        int idx1 = len;
        int idx2 = otherLen;
        for (i = 0; i < minLen && Objects.equals(sym1 = this.getSymbol(--idx1), sym2 = other.getSymbol(--idx2)); ++i) {
        }
        return this.suffix(i);
    }

    @Nonnull
    public Word<I> flatten() {
        int len = this.length();
        Object[] array = new Object[len];
        this.writeToArray(0, array, 0, len);
        return new SharedWord(array);
    }

    @Nonnull
    public Word<I> trimmed() {
        int len = this.length();
        Object[] array = new Object[len];
        this.writeToArray(0, array, 0, len);
        return new SharedWord(array);
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int[] toIntArray(ToIntFunction<? super I> toInt) {
        int len = this.length();
        int[] result = new int[len];
        int i = 0;
        for (I sym : this) {
            int symIdx = toInt.applyAsInt(sym);
            result[i++] = symIdx;
        }
        return result;
    }

    @Nonnull
    public <T> Word<T> transform(Function<? super I, ? extends T> transformer) {
        int len = this.length();
        Object[] array = new Object[len];
        int i = 0;
        for (I symbol : this) {
            array[i++] = transformer.apply(symbol);
        }
        return new SharedWord(array);
    }

    public static <I> Word<I> upcast(Word<? extends I> word) {
        return word;
    }

    static {
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        emptyWordRep = settings.getProperty("word.empty", "\u03b5");
        wordDelimLeft = settings.getProperty("word.delim.left", "");
        wordDelimRight = settings.getProperty("word.delim.right", "");
        wordSymbolSeparator = settings.getProperty("word.symbol.separator", " ");
        wordSymbolDelimLeft = settings.getProperty("word.symbol.delim.left", "");
        wordSymbolDelimRight = settings.getProperty("word.symbol.delim.right", "");
    }

    private class AsList
    extends AbstractList<I> {
        private AsList() {
        }

        @Override
        @Nullable
        public I get(int index) {
            return Word.this.getSymbol(index);
        }

        @Override
        public int size() {
            return Word.this.length();
        }

        @Override
        @Nonnull
        public java.util.Iterator<I> iterator() {
            return Word.this.iterator();
        }
    }

    private class Iterator
    implements java.util.Iterator<I> {
        private int index = 0;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Word.this.length();
        }

        @Override
        @Nullable
        public I next() {
            if (this.index >= Word.this.length()) {
                throw new NoSuchElementException();
            }
            return Word.this.getSymbol(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

