/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.Objects;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

public class ArrayAlphabet<I>
extends AbstractAlphabet<I> {
    protected final I[] symbols;

    @SafeVarargs
    public ArrayAlphabet(I ... symbols) {
        this.symbols = symbols;
    }

    @Override
    public I getSymbol(int index) throws IllegalArgumentException {
        return this.symbols[index];
    }

    @Override
    public int getSymbolIndex(I symbol) throws IllegalArgumentException {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!Objects.equals(this.symbols[i], symbol)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.symbols.length;
    }

    @Override
    public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        System.arraycopy(this.symbols, offset, array, tgtOfs, num);
    }

    @Override
    public boolean containsSymbol(I symbol) {
        return this.getSymbolIndex(symbol) != -1;
    }
}

