/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.cs.tree;

import java.util.ArrayList;
import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.iterator.EmptyTreeIterator;
import nl.ru.cs.tree.iterator.TreeIterator;
import nl.ru.cs.tree.iterator.TreeIteratorDepthFirstPreOrder;

public class Tree<T>
implements Iterable<TreeNode<T>> {
    private TreeNode<T> root;
    private TreeIterator<TreeNode<T>> iterator;

    public Tree() {
    }

    public Tree(TreeNode<T> root) {
        this.setRoot(root);
    }

    public Tree(TreeNode<T> root, TreeIterator<TreeNode<T>> iterator) {
        this.setRoot(root);
        this.setIterator(iterator);
    }

    public Tree<T> getShallowCopy(TreeIterator<TreeNode<T>> iterator) {
        return new Tree<T>(this.getRoot(), iterator);
    }

    public TreeNode<T> getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode<T> root) {
        this.root = root;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public void setIterator(TreeIterator<TreeNode<T>> iterator) {
        this.iterator = iterator;
    }

    @Override
    public TreeIterator<TreeNode<T>> iterator() {
        if (this.isEmpty()) {
            return new EmptyTreeIterator();
        }
        if (this.iterator == null) {
            this.iterator = new TreeIteratorDepthFirstPreOrder<T>(this.root);
        }
        TreeIterator<TreeNode<T>> t = this.iterator.newInstance();
        return this.iterator.newInstance();
    }

    public String toString() {
        ArrayList<TreeNode> returnList = new ArrayList<TreeNode>();
        for (TreeNode currentNode : this) {
            returnList.add(currentNode);
        }
        return ((Object)returnList).toString();
    }

    public int size() {
        int numberOfNodes = 0;
        Tree<T> shallowCopy = this.getShallowCopy(new TreeIteratorDepthFirstPreOrder<T>(this.root));
        for (TreeNode treeNode : shallowCopy) {
            ++numberOfNodes;
        }
        return numberOfNodes;
    }
}

