/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.cs.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeNode<T> {
    private T data;
    private List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
    private TreeNode<T> parent = null;

    public TreeNode() {
    }

    public TreeNode(T data) {
        this();
        this.setData(data);
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public List<TreeNode<T>> getChildrenReversed() {
        ArrayList<TreeNode<T>> lst = new ArrayList<TreeNode<T>>(this.children);
        Collections.reverse(lst);
        return lst;
    }

    public TreeNode<T> getChildAt(int index) throws IndexOutOfBoundsException {
        return this.children.get(index);
    }

    public int getNumberOfChildren() {
        return this.getChildren().size();
    }

    public boolean hasChildren() {
        return this.getNumberOfChildren() > 0;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void setChildren(List<TreeNode<T>> children) {
        for (TreeNode<T> child : children) {
            child.parent = this;
        }
        this.children = children;
    }

    public void addChild(TreeNode<T> child) {
        child.parent = this;
        this.children.add(child);
    }

    public void addChildAt(int index, TreeNode<T> child) throws IndexOutOfBoundsException {
        child.parent = this;
        this.children.add(index, child);
    }

    public void removeChildren() {
        this.children = new ArrayList<TreeNode<T>>();
    }

    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return this.getData().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }
}

