/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.cs.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.ru.cs.tree.Tree;
import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.iterator.TreeIteratorUpwards;

public class TreeUtils {
    public static int getNumberOfNodes(Tree<?> tree) {
        return tree.size();
    }

    public static int getNumberOfEndNodes(Tree<?> tree) {
        int numberOfEndNodes = 0;
        for (TreeNode treeNode : tree) {
            if (treeNode.getNumberOfChildren() != 0) continue;
            ++numberOfEndNodes;
        }
        return numberOfEndNodes;
    }

    public static <T> TreeNode<T> find(T dataToFind, Tree<T> tree) {
        TreeNode<T> returnNode = null;
        for (TreeNode treeNode : tree) {
            if (!treeNode.getData().equals(dataToFind)) continue;
            return treeNode;
        }
        return returnNode;
    }

    public static <T> boolean exists(T dataToFind, Tree<T> tree) {
        return TreeUtils.find(dataToFind, tree) != null;
    }

    public static <T> List<TreeNode<T>> toList(Tree<T> tree) {
        ArrayList<TreeNode<T>> returnList = new ArrayList<TreeNode<T>>();
        for (TreeNode treeNode : tree) {
            returnList.add(treeNode);
        }
        return returnList;
    }

    public static <T> Map<TreeNode<T>, Integer> getNode2DepthMap(Tree<T> tree) {
        HashMap<TreeNode<T>, Integer> node2depth = new HashMap<TreeNode<T>, Integer>();
        if (tree.isEmpty()) {
            return node2depth;
        }
        node2depth.put(tree.getRoot(), 0);
        for (TreeNode treeNode : tree) {
            TreeNode parent = treeNode.getParent();
            if (parent == null) continue;
            int parentDepth = (Integer)node2depth.get(parent);
            node2depth.put(treeNode, parentDepth + 1);
        }
        return node2depth;
    }

    public static <T> Map<Integer, Integer> getDepthIndex(Tree<T> tree) {
        HashMap<Integer, Integer> depth2numNodes = new HashMap<Integer, Integer>();
        Map<TreeNode<T>, Integer> node2depth = TreeUtils.getNode2DepthMap(tree);
        for (TreeNode treeNode : tree) {
            int depth = node2depth.get(treeNode);
            if (depth2numNodes.containsKey(depth)) {
                int numNodes = (Integer)depth2numNodes.get(depth);
                depth2numNodes.put(depth, numNodes + 1);
                continue;
            }
            depth2numNodes.put(depth, 1);
        }
        return depth2numNodes;
    }

    public static <T> List<TreeNode<T>> getTraceFromNodeToRoot(TreeNode<T> currentNode, Tree<T> tree) {
        ArrayList<TreeNode<T>> returnList = new ArrayList<TreeNode<T>>();
        Tree<T> treeWithUpwardsIterator = tree.getShallowCopy(new TreeIteratorUpwards<T>(currentNode));
        for (TreeNode treeNode : treeWithUpwardsIterator) {
            returnList.add(treeNode);
        }
        return returnList;
    }

    public static <T> List<TreeNode<T>> getTraceFromRootToNode(TreeNode<T> currentNode, Tree<T> tree) {
        List<TreeNode<T>> returnList = TreeUtils.getTraceFromNodeToRoot(currentNode, tree);
        Collections.reverse(returnList);
        return returnList;
    }
}

