/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.cs.tree.iterator;

import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.iterator.TreeIterator;

public abstract class TreeIteratorAbstract<T>
implements TreeIterator<TreeNode<T>> {
    protected TreeNode<T> startNode;
    protected TreeNode<T> nextNode;

    public TreeIteratorAbstract(TreeNode<T> startNode) {
        this.setStartNode(startNode);
        this.reset();
    }

    @Override
    public abstract void reset();

    @Override
    public void setStartNode(TreeNode<T> startNode) {
        this.startNode = startNode;
    }

    @Override
    public TreeNode<T> getStartNode() {
        return this.startNode;
    }

    public abstract TreeNode<T> fetchNext();

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public TreeNode<T> next() {
        if (this.hasNext()) {
            return this.fetchNext();
        }
        throw new IndexOutOfBoundsException("no nodes in tree to traversal anymore");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("the tree iterator does not implement the remove method");
    }
}

