/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.cs.tree.iterator;

import java.util.LinkedList;
import java.util.Stack;
import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.iterator.TreeIterator;
import nl.ru.cs.tree.iterator.TreeIteratorAbstract;

public class TreeIteratorDepthFirstPostOrder<T>
extends TreeIteratorAbstract<T>
implements TreeIterator<TreeNode<T>> {
    protected Stack<Integer> childIndexes = new Stack();
    protected int currentNodeIndex;
    protected LinkedList<TreeNode<T>> nodeCache = new LinkedList();
    protected TreeNode<T> currentNode;

    public TreeIteratorDepthFirstPostOrder(TreeNode<T> startNode) {
        super(startNode);
    }

    @Override
    public TreeIteratorDepthFirstPostOrder<T> newInstance() {
        return new TreeIteratorDepthFirstPostOrder<T>(this.startNode);
    }

    @Override
    public void reset() {
        this.nextNode = this.startNode;
        this.currentNode = this.startNode;
    }

    private void walkMostLeftDownwards() {
        if (this.currentNode.hasChildren()) {
            this.childIndexes.push(this.currentNodeIndex);
            this.currentNode = this.currentNode.getChildAt(0);
            this.currentNodeIndex = 0;
            this.walkMostLeftDownwards();
        } else {
            this.nodeCache.add(this.currentNode);
        }
    }

    private void walkToNextSibling() {
        if (this.currentNode == this.startNode) {
            this.currentNode = null;
            return;
        }
        if (this.currentNodeIndex + 1 < this.currentNode.getParent().getNumberOfChildren()) {
            ++this.currentNodeIndex;
            this.currentNode = this.currentNode.getParent().getChildAt(this.currentNodeIndex);
        } else {
            this.currentNode = this.currentNode.getParent();
            this.currentNodeIndex = this.childIndexes.pop();
            this.nodeCache.add(this.currentNode);
            this.walkToNextSibling();
        }
    }

    private void walkToNextRightDownwardsSibling() {
        this.walkMostLeftDownwards();
        this.walkToNextSibling();
    }

    TreeNode<T> getNextNode() {
        if (this.nodeCache.isEmpty() && this.currentNode != null) {
            this.walkToNextRightDownwardsSibling();
        }
        if (this.nodeCache.isEmpty()) {
            return null;
        }
        return this.nodeCache.remove();
    }

    @Override
    public TreeNode<T> fetchNext() {
        if (this.currentNode == this.startNode) {
            this.nextNode = this.getNextNode();
        }
        TreeNode node = this.nextNode;
        this.nextNode = this.getNextNode();
        return node;
    }
}

