/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.cs.tree.iterator;

import java.util.ListIterator;
import java.util.Stack;
import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.iterator.TreeIterator;
import nl.ru.cs.tree.iterator.TreeIteratorAbstract;

public class TreeIteratorDepthFirstPreOrder<T>
extends TreeIteratorAbstract<T>
implements TreeIterator<TreeNode<T>> {
    protected Stack<TreeNode<T>> visiting;

    public TreeIteratorDepthFirstPreOrder(TreeNode<T> startNode) {
        super(startNode);
    }

    @Override
    public TreeIteratorDepthFirstPreOrder<T> newInstance() {
        return new TreeIteratorDepthFirstPreOrder<T>(this.startNode);
    }

    @Override
    public void reset() {
        this.nextNode = this.startNode;
        this.visiting = new Stack();
        this.visiting.push(this.startNode);
    }

    @Override
    public TreeNode<T> fetchNext() {
        TreeNode<T> node = this.visiting.pop();
        ListIterator<TreeNode<T>> it = node.getChildren().listIterator(node.getNumberOfChildren());
        while (it.hasPrevious()) {
            TreeNode<T> child = it.previous();
            this.visiting.push(child);
        }
        if (this.visiting.empty()) {
            this.nextNode = null;
        }
        return node;
    }
}

