/*
 * Decompiled with CFR 0.152.
 */
package nl.ru.cs.tree.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import nl.ru.cs.tree.Tree;
import nl.ru.cs.tree.TreeNode;
import nl.ru.cs.tree.util.EdgeNode;

public class Dot {
    public static List<String> tree2dot(Tree<EdgeNode> tree) {
        String indent = "    ";
        LinkedList<String> lines = new LinkedList<String>();
        HashSet<String> nodes = new HashSet<String>();
        ArrayList<EdgeTriple> transitions = new ArrayList<EdgeTriple>();
        lines.add("digraph g {");
        for (TreeNode treeNode : tree) {
            TreeNode parent = treeNode.getParent();
            if (parent == null) continue;
            String src = ((EdgeNode)parent.getData()).node;
            String dest = ((EdgeNode)treeNode.getData()).node;
            String label = ((EdgeNode)treeNode.getData()).edge;
            transitions.add(new EdgeTriple(src, dest, label));
            nodes.add(src);
            nodes.add(dest);
        }
        ArrayList sortedNodes = new ArrayList(nodes);
        sortedNodes.sort((p1, p2) -> p1.compareTo((String)p2));
        Collections.sort(transitions);
        for (String nodeLabel : sortedNodes) {
            lines.add(indent + nodeLabel + " [shape=\"circle\" label=\"" + nodeLabel + "\"];");
        }
        for (EdgeTriple transition : transitions) {
            lines.add(indent + transition.src + " -> " + transition.dest + " [label=\"" + transition.label + "\"];");
        }
        lines.add("}");
        return lines;
    }

    private static class EdgeTriple
    implements Comparable<EdgeTriple> {
        String src;
        String dest;
        String label;

        public EdgeTriple(String label1, String label2, String label3) {
            this.src = label1;
            this.dest = label2;
            this.label = label3;
        }

        @Override
        public int compareTo(EdgeTriple o) {
            int result = this.src.compareTo(o.src);
            if (result != 0) {
                return result;
            }
            result = this.dest.compareTo(o.dest);
            if (result != 0) {
                return result;
            }
            return this.label.compareTo(o.label);
        }
    }
}

