/*
 * Decompiled with CFR 0.152.
 */
package exceptionslib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DecoratedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private List<Decoration> decorations = new ArrayList<Decoration>();

    public DecoratedRuntimeException() {
    }

    public DecoratedRuntimeException(String msg) {
        super(msg);
    }

    public DecoratedRuntimeException addDecoration(String description, Object decorativeObject) {
        this.decorations.add(new Decoration(description, decorativeObject));
        return this;
    }

    @Override
    public String toString() {
        return "\n\n" + this.decorationsToString() + "\n" + super.toString();
    }

    public String decorationsToString() {
        StringBuilder builder = new StringBuilder();
        for (Decoration decoration : this.decorations) {
            builder.append(decoration.toString()).append("\n");
        }
        return builder.toString();
    }

    private static class Decoration {
        private Object decoration;
        private String description;

        public Decoration(String description, Object decoration) {
            this.decoration = decoration;
            this.description = description;
        }

        public String toString() {
            return String.valueOf(this.description) + ":" + this.decorationsToString();
        }

        public String decorationsToString() {
            StringBuilder builder = new StringBuilder();
            if (this.decoration instanceof Collection) {
                builder.append("\n");
                for (Object element : (Collection)this.decoration) {
                    builder.append(element).append("\n");
                }
            } else {
                builder.append(this.decoration);
            }
            return builder.toString();
        }
    }
}

