/*
 * Decompiled with CFR 0.152.
 */
package com.github.misberner.graphvizawtshapes.shapes;

import com.github.misberner.graphvizawtshapes.shapes.ShapeUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;

public class MultiShape
implements Shape {
    private final Shape outermost;
    private final List<Shape> allShapes;

    public MultiShape(Shape ... shapes) {
        this.allShapes = Arrays.asList(shapes);
        this.outermost = shapes[0];
    }

    @Override
    public Rectangle getBounds() {
        return this.outermost.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.outermost.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.outermost.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.outermost.contains(p);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.outermost.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.outermost.intersects(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.outermost.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.outermost.contains(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return ShapeUtil.concatPathIterators(this.allShapes, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return ShapeUtil.concatPathIterators(this.allShapes, at, flatness);
    }
}

