@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  stm startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and STM_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\statemachinelib.jar;%APP_HOME%\lib\exceptionslib-20170320-345d975.jar;%APP_HOME%\lib\antlr4-4.5.3.jar;%APP_HOME%\lib\javatuples-1.2.jar;%APP_HOME%\lib\argparse4j-0.8.1.jar;%APP_HOME%\lib\org.eclipse.jdt.annotation_2.1.0.v20160418-1457.jar;%APP_HOME%\lib\generictree.jar;%APP_HOME%\lib\symtab-1.0.8.jar;%APP_HOME%\lib\commons-logging-1.1.jar;%APP_HOME%\lib\ognl-2.6.9.jar;%APP_HOME%\lib\commons-collections-3.2.jar;%APP_HOME%\lib\commons-lang-2.3.jar;%APP_HOME%\lib\unitils-core-3.4.2.jar;%APP_HOME%\lib\concurrent-1.3.4.jar;%APP_HOME%\lib\jung-api-2.0.1.jar;%APP_HOME%\lib\guava-18.0.jar;%APP_HOME%\lib\jung-algorithms-2.0.1.jar;%APP_HOME%\lib\wstx-asl-3.2.6.jar;%APP_HOME%\lib\automata-parent-0.6.1-sha1-601e6fe.jar;%APP_HOME%\lib\jung-visualization-2.0.1.jar;%APP_HOME%\lib\graphviz-awt-shapes-0.0.1.jar;%APP_HOME%\lib\colt-1.2.0.jar;%APP_HOME%\lib\jung-graph-impl-2.0.1.jar;%APP_HOME%\lib\jung-io-2.0.1.jar;%APP_HOME%\lib\stax-api-1.0.1.jar;%APP_HOME%\lib\jsr305-2.0.3.jar;%APP_HOME%\lib\collections-generic-4.01.jar;%APP_HOME%\lib\automaton-1.11-8.jar

@rem Execute stm
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %STM_OPTS%  -classpath "%CLASSPATH%" statemachine.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable STM_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%STM_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
